
//#include <windows.h>
#include <iostream>
#include "strategy.h"
#include <time.h>
#include <string>
#include <set>

using namespace std;

/*
本策略每隔1个月定时触发计算SHSE.000300成份股的过去一天EV / EBITDA值并选取30只EV / EBITDA值最小且大于零的股票
对不在股票池的股票平仓并等权配置股票池的标的
并用相应的CFFEX.IF对应的真实合约等额对冲
回测数据为 : SHSE.000300和他们的成份股和CFFEX.IF对应的真实合约
回测时间为 : 2017 - 07 - 01 08 : 00 : 00到2017 - 10 - 01 16 : 00 : 00
*/


class MyStrategy :public Strategy
{
public:
	MyStrategy() {}
	~MyStrategy(){}

	void on_init()
	{
		//每月第一个交易日09:40:00的定时执行任务
		schedule("1m","09:40:00");
		return;
	}


	void on_schedule(const char *data_rule, const char *time_rule)
	{
		//获取当前时刻
		long long t = now();
		char time_now[64];
		struct tm *ttime = new struct tm;
		localtime_s(ttime, &t);
		strftime(time_now, 64, "%Y-%m-%d %H:%M:%S", ttime);
		cout << "time: " << time_now << endl;

		//获取上一个交易日
		char last_day[32] = { 0 };
		get_previous_trading_date("SHSE", time_now, last_day);

		//获取沪深300成份股
		DataSet* stock300 = get_constituents("SHSE.000300", last_day);
		//获取深沪300成分股标的代码
		string stock300_s = "";
		if (stock300->status() == 0)
		{	
			while (!stock300->is_end())  //判断是否已经到达结果集末尾
			{
				stock300_s += stock300->get_string("symbol");
				stock300->next(); //移动到下一条记录
				if (!stock300->is_end())
				{
					stock300_s += ",";
				}
			}
		}
		else
		{
			cout << "get_constituents error: " << stock300->status() << endl;
		}
		const char *stock300_symbol = stock300_s.c_str();
		stock300 -> release();

		//获取上一个工作日的CFFEX.IF对应的合约
		DataSet* index_futures = get_continuous_contracts("CFFEX.IF", last_day,last_day);
		string index_futures_s = "";
		if (index_futures -> status() == 0)
		{
			while (!index_futures->is_end())
			{
				index_futures_s = index_futures->get_string("symbol");
				index_futures->next();
			}
		}
		const char* index_futures_symbol = index_futures_s.c_str();
		index_futures->release();

		//获取当天有交易的股票
		DataSet* not_suspended_info = get_history_instruments(stock300_symbol, time_now, time_now);
		string not_suspended_s = "";

		if (not_suspended_info->status() == 0)
		{
			while (!not_suspended_info->is_end())  //判断是否已经到达结果集末尾以及是否停牌
			{
				if (!not_suspended_info->get_integer("is_suspended"))
				{
					not_suspended_s += not_suspended_info->get_string("symbol");
					not_suspended_s += ",";
				}

				not_suspended_info->next();
			}

			if (!not_suspended_s.empty() || not_suspended_s.back() == ',')
			{
				not_suspended_s.erase(not_suspended_s.size() -1);
			}
		}
		else
		{
			cout << "get_history_instruments error: " << not_suspended_info->status() << endl;
		}
		const char *not_suspended_symbols = not_suspended_s.c_str();

		not_suspended_info->release();
		//获取成份股EV/EBITDA大于0并为最小的30个

		DataSet* fin = get_fundamentals("trading_derivative_indicator", not_suspended_symbols,time_now, time_now, "EVEBITDA","EVEBITDA>0", "EVEBITDA", 30);
		set <string> fin_symbol;
		if (fin->status() == 0)
		{
			while (!fin->is_end())
			{
				fin_symbol.insert(fin->get_string("symbol"));
				fin->next();
			}
		}
		else
		{
			cout << "get_fundamentals error: " << fin->status() << endl;
		}
		fin->release();



		//获取当前仓位
		DataArray<Position>* positions = get_position();
		if (positions->status() == 0) //判断查询是否成功
		{
			//平不在标的池或不为当前股指期货主力合约对应真实合约的标的
			for (int i = 0; i < positions->count(); i++)
			{
				char* symbol = positions->at(i).symbol;
				int sec_type = get_instrumentinfos(symbol) -> get_integer("sec_type");
				//若类型为期货且不在标的池则平仓
				if (sec_type == 4 && symbol != index_futures_symbol)
				{
					order_target_percent(symbol, 0,  PositionSide_Short, OrderType_Market);
					cout << "not exist" << symbol << endl;
				}
				else if (fin_symbol.find(symbol) == fin_symbol.end())
				{
					order_target_percent(symbol, 0, PositionSide_Long, OrderType_Market);
					cout << "not exist" << symbol << endl;
				}
			}

			//获取股票的权重
			double percent = m_percentage_stock / fin_symbol.size();
			//买在标的池中的股票
			for (string symbol : fin_symbol)
			{
				order_target_percent(symbol.c_str(), percent, PositionSide_Long, OrderType_Market);
				cout << symbol <<"more" << percent << endl;
			}
			//获取股指期货的保证金比率
			double ratio = get_history_instruments(index_futures_symbol, last_day, last_day)->get_real("margin_ratio");
			//更新股指期货的权重
			percent = m_percentage_futures * ratio;
			//买入股指期货对冲
			order_target_percent(index_futures_symbol, percent, PositionSide_Short, OrderType_Market);
			cout << index_futures_symbol << "less" << percent << endl;
		}
	}

private:
	//设置开仓在股票和期货的资金百分比(期货在后面自动进行杠杆相关的调整)
	double m_percentage_stock = 0.4;
	double m_percentage_futures = 0.4;
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2017-07-01 08:00:00", "2017-10-01 16:00:00",
		10000000, 1, 0.0001, 0.0001, 1, 1);
	s.run();
	cout << "`press any key to exit!`" << endl;
	
	getchar();
	return 0;
}
