//////////////////////////////////////////////////////////////////////////
//数据研究
//策略描述：
//无需实时数据驱动策略，无需交易下单，只是取数据的场景

#include <iostream>
#include "strategy.h"

using namespace std;

class MyStrategy :public Strategy
{
public:
	MyStrategy() {}
	~MyStrategy(){}

	//重写on_init事件，进行策略开发
	void on_init()
	{
		cout << "on_init" << endl;

		DataArray<Tick>* ht = history_ticks("SZSE.000002", "2017-07-11 10:20:00", "2017-07-11 10:30:00");
		if (ht->status() == 0)
		{
			for (int i = 0; i < ht->count(); i++)
			{
				cout << "代码:                               " << ht->at(i).symbol << endl
					<< "utc时间，精确到毫秒:                 " << ht->at(i).created_at << endl
					<< "最新价:                              " << ht->at(i).price << endl
					<< "开盘价:                              " << ht->at(i).open << endl
					<< "最高价:                              " << ht->at(i).high << endl
					<< "最低价:                              " << ht->at(i).low << endl
					<< "成交总量:                            " << ht->at(i).cum_volume << endl
					<< "成交总金额 / 最新成交额, 累计值:     " << ht->at(i).cum_amount << endl
					<< "合约持仓量(期), 累计值:              " << ht->at(i).cum_position << endl
					<< "瞬时成交额:                          " << ht->at(i).last_amount << endl
					<< "瞬时成交量:                          " << ht->at(i).last_volume << endl
					<< "保留)交易类型, 对应多开, 多平等类型: " << ht->at(i).trade_type << endl
					<< "报价:                                " << ht->at(i).quotes << endl;
			}
		}

		return;
	}

private:
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2017-07-11 10:20:00", "2017-07-11 10:30:00",
		1000000, 1, 0, 0, 0, 1);

	s.run();
	return 0;
}