//////////////////////////////////////////////////////////////////////////
//显示指定交易账号
//策略描述：
//下单时指定交易账号，account参数传账号id或者账号标题

#include <iostream>
#include "strategy.h"

using namespace std;

class MyStrategy :public Strategy
{
public:
	MyStrategy() {}
	~MyStrategy(){}

	//重写on_init事件，进行策略开发
	void on_init()
	{
		cout << "on_init" << endl;
		subscribe("SHSE.600000,SZSE.000001", "1d");

		return;
	}

	void on_bar(Bar *bar)
	{
		//不指定account 使用默认账户下单
		order_volume(bar->symbol, 200, 1, 2, 1, 0, "ba8785aa-8641-11e8-98cb-7085c223669d");
	}

	//回测完成事件
	void on_backtest_finished()
	{
		cout << "on_backtest_finished" << endl;
	}

	//回测完成后收到绩效报告
	void on_indicator(Indicator *indicator)
	{
		cout << "on_indicator" << endl
			<< "账号ID:       " << indicator->account_id << endl
			<< "累计收益率:   " << indicator->pnl_ratio << endl
			<< "年化收益率:   " << indicator->pnl_ratio_annual << endl
			<< "夏普比率:     " << indicator->sharp_ratio << endl
			<< "最大回撤:     " << indicator->max_drawdown << endl
			<< "风险比率:     " << indicator->risk_ratio << endl
			<< "开仓次数:     " << indicator->open_count << endl
			<< "平仓次数:     " << indicator->close_count << endl
			<< "盈利次数:     " << indicator->win_count << endl
			<< "亏损次数:     " << indicator->lose_count << endl
			<< "胜率:         " << indicator->win_ratio << endl
			<< "指标创建时间: " << indicator->created_at << endl
			<< "指标变更时间: " << indicator->updated_at << endl;
	}

private:
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2016-07-11 17:20:00", "2017-07-11 17:30:00",
		1000000, 1, 0, 0, 0, 1);
	s.run();
	return 0;
}