//////////////////////////////////////////////////////////////////////////
//空策略

#include <iostream>
#include "strategy.h"
#include <string>
#include <vector>
#include <numeric>
#include <algorithm>

using namespace std;


/*
本策略首先计算了SHFE.rb1801过去300个1min收盘价的均值和标准差
并用均值加减2和3个标准差得到网格的区间分界线,分别配以0.3和0.5的仓位权重
然后根据价格所在的区间来配置仓位:
(n+k1*std,n+k2*std],(n+k2*std,n+k3*std],(n+k3*std,n+k4*std],(n+k4*std,n+k5*std],(n+k5*std,n+k6*std]
(n为收盘价的均值,std为收盘价的标准差,k1-k6分别为[-40, -3, -2, 2, 3, 40],其中-40和40为上下界,无实际意义)
[-0.5, -0.3, 0.0, 0.3, 0.5](资金比例,此处负号表示开空仓)
回测数据为:SHFE.rb1801的1min数据
回测时间为:2017-07-01 08:00:00到2017-10-01 16:00:00
*/



class MyStrategy :public Strategy
{
public:
	MyStrategy() 
	{
		m_weight[0] = 0.5;
		m_weight[1] = 0.3;
		m_weight[2] = 0.0;
		m_weight[3] = 0.3;
		m_weight[4] = 0.5;

		m_band[0] = -40;
		m_band[1] = -3;
		m_band[2] = -2;
		m_band[3] = 2;
		m_band[4] = 3;
		m_band[5] = 40;
	}

	~MyStrategy()
	{

	}

	//重写on_init事件，进行策略开发
	void on_init()
	{
		//订阅SHFE.rb1801, bar频率为1min
		subscribe(m_symbol, "60s");
		//获取过去300个价格数据
		DataArray<Bar>* history300_bars = history_bars_n(m_symbol, "60s", 300, "2017-07-01 08:00:00", 0, NULL, true, "Last");
		vector<double> timeseries;

		if (history300_bars->status() == 0) //判断查询是否成功
		{
			for (int i = 0; i < history300_bars->count(); i++)
			{
				timeseries.push_back(history300_bars->at(i).close);
			}
		}
		history300_bars->release();

		//获取网格区间分界线
		double sum = accumulate(begin(timeseries), end(timeseries), 0.0);
		double mean = sum / timeseries.size(); //均值
		double accum = 0.0;
		for_each(std::begin(timeseries), std::end(timeseries), [&](const double d) {
			accum += (d - mean)*(d - mean);
		});
		double stdev = sqrt(accum / (timeseries.size() - 1));
		cout << "std dev: " << stdev << endl;

		for (int i = 0; i < sizeof(m_band)/sizeof(double); i++)
		{
			m_band[i] = mean + m_band[i] * stdev;
		}


		return;
	}
	void on_bar(Bar *bar)
	{
		double bar_close = bar->close;
		//根据价格落在(-40,-3],(-3,-2],(-2,2],(2,3],(3,40]的区间范围来获取最新收盘价所在的价格区间


		int grid = -1;
		if (bar_close>m_band[0] && bar_close <= m_band[1])
		{
			grid = 0;
		}
		else if (bar_close>m_band[1] && bar_close <= m_band[2])
		{
			grid = 1;
		}
		else if (bar_close>m_band[2] && bar_close <= m_band[3])
		{
			grid = 2;
		}
		else if (bar_close>m_band[3] && bar_close <= m_band[4])
		{
			grid = 3;
		}
		else if (bar_close>m_band[4] && bar_close <= m_band[5])
		{
			grid = 4;
		}
		
		DataArray<Position>* positions = get_position();
		
		bool position_long = false;
		bool position_short = false;
		if (positions->status() == 0 && positions->count() > 0)
		{
			//获取多仓仓位
			position_long = (positions->at(0).side == 1) ? true : false;
			//获取空仓仓位
			position_short = (positions->at(0).side == 2) ? true : false;
		}

		positions->release();

		//若无仓位且价格突破则按照设置好的区间开仓
		if (grid > -1)
		{
			if (!position_long && !position_short && grid != 2)
			{
				//大于3为在中间网格的上方,做多

				if (grid >= 3)
				{
					order_target_percent(m_symbol, m_weight[grid], PositionSide_Long, OrderType_Market);
					cout << m_symbol << "yi shi jia dan kai duo cang dao cang wei: " << m_weight[grid] << endl;
				}

				if (grid <= 1)
				{
					order_target_percent(m_symbol, m_weight[grid], PositionSide_Short, OrderType_Market);
					cout << m_symbol << "yi shi jia dan kai kong cang dao cang wei: " << m_weight[grid] << endl;
				}
			}
			//持有多仓的处理
			else if (position_long)
			{
				if (grid >= 3)
				{
					order_target_percent(m_symbol, m_weight[grid], PositionSide_Long, OrderType_Market);
					cout << m_symbol << "yi shi jia dan kai duo cang dao cang wei: " << m_weight[grid] << endl;
				}
				//等于2为在中间网格,平仓
				else if (grid == 2)
				{
					order_target_percent(m_symbol, 0, PositionSide_Long, OrderType_Market);
					cout << m_symbol << "yi shi jia dan quan ping duo cang" << endl;
				}
				//小于1为在中间网格的下方,做空
				else if (grid <= 1)
				{
					order_target_percent(m_symbol, 0, PositionSide_Long, OrderType_Market);
					cout << m_symbol << "yi shi jia dan quan ping duo cang" << endl;
					order_target_percent(m_symbol, m_weight[grid], PositionSide_Short, OrderType_Market);
					cout << m_symbol << "yi shi jia dan kai kong cang dao cang wei: " << m_weight[grid] << endl;
				}
			}
			//持有空仓的处理
			else if (position_short)
			{
				//小于1为在中间网格的下方,做空
				if (grid <= 1)
				{
					order_target_percent(m_symbol, m_weight[grid], PositionSide_Short, OrderType_Market);
					cout << m_symbol << "yi shi jia dan tiao kong cang dao cang wei: " << m_weight[grid] << endl;
				}
				//等于2为在中间网格, 平仓
				else if (grid == 2)
				{
					order_target_percent(m_symbol, 0, PositionSide_Short, OrderType_Market);
					cout << m_symbol << "yi shi jia dan quan ping kong cang" << endl;
				}
				//大于3为在中间网格的上方, 做多
				else if (grid >= 3)
				{
					order_target_percent(m_symbol, 0, PositionSide_Short, OrderType_Market);
					cout << m_symbol << "yi shi jia dan quan ping kong cang" << endl;
					order_target_percent(m_symbol, m_weight[grid], PositionSide_Long, OrderType_Market);
					cout << m_symbol << "yi shi jia dan kai duo cang dao cang wei: " << m_weight[grid] << endl;
				}

			}
		}
	}

private:
	const char* m_symbol = "SHFE.rb1801";

	double m_band[6];
	double m_weight[5];
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2017-07-01 08:00:00", "2017-10-01 16:00:00",
		10000000, 1, 0.0001, 0.0001, 1, 1);
	s.run();
	cout << "`press any key to exit!`" << endl;
	getchar();
	return 0;
}
