//////////////////////////////////////////////////////////////////////////
//空策略

#include <iostream>
#include "strategy.h"
#include <vector>
#include <time.h>
#include <string>
#include "svm.h"
#include <list>
#include <numeric>
#include <algorithm>

using namespace std;

class MyStrategy :public Strategy
{
public:
	MyStrategy() 
	{
		m_symbol = "SHSE.600009";
	}
	~MyStrategy(){}

	void on_init()
	{
		//订阅上海机场的分钟bar行情
		subscribe(m_symbol, "60s");

		const char* start_date = "2016-03-01";    // SVM训练起始时间
		const char* end_date = "2017-06-30";      // SVM训练终止时间
		// 用于记录工作日
		// 获取目标股票的daily历史行情
		vector<string> days_value;
		vector <float> days_close;

		DataArray<Bar>* recent_data = history_bars(m_symbol, "1d", start_date, end_date, 0, NULL, true, "Last");
		if (recent_data->status() == 0) //判断查询是否成功
		{
			for (int i = 0; i < recent_data->count(); i++)
			{
				long long t = recent_data->at(i).bob;
				char time_now[64];
				struct tm *ttime = new struct tm;

				localtime_s(ttime, &t);

				strftime(time_now, 64, "%Y-%m-%d %H:%M:%S", ttime);
				string temp(time_now);
				
				days_value.push_back(temp);
				days_close.push_back(recent_data->at(i).close);
			}
		}
		recent_data->release();

		
		//获取行情日期列表
		cout << "Preparing data for SVM training" << endl;

		int feature_i = 0;
		prob.l = days_close.size() - 20;
		prob.x = new svm_node *[prob.l];
		prob.y = new double[prob.l];
		for (int index = 15; index <= days_value.size() - 5; index++)
		{
			string start_day = days_value[index - 15];
			string end_day = days_value[index];
			vector<float> close;
			vector<float> max_x;
			vector<float> min_n;
			vector<double> amount;
			vector<double> volume;
			DataArray<Bar>*data = history_bars(m_symbol, "1d", start_day.c_str(), end_day.c_str(), 0, NULL, true, "Last");
			if (data->status() == 0) //判断查询是否成功
			{
				//遍历行情数组
				for (int i = 0; i < data->count(); i++)
				{
					close.push_back(data->at(i).close);
					max_x.push_back(data->at(i).high);
					min_n.push_back(data->at(i).low);
					amount.push_back(data->at(i).amount);
					volume.push_back(amount[i] / close[i]);
				}
			}
			data->release();

			// 收盘价 / 均值
			float close_m = (accumulate(begin(close), end(close), 0.0) / close.size());
			float close_mean = close.back() / close_m;
			// 现量/均量
			float volume_mean = volume.back() / (accumulate(begin(volume), end(volume), 0.0) / volume.size());
			// 最高价/均价
			float max_mean = max_x.back() / (accumulate(begin(max_x), end(max_x), 0.0) / max_x.size());
			// 最低价/均价
			float min_mean = min_n.back() / (accumulate(begin(min_n), end(min_n), 0.0) / min_n.size());
			// 现量
			double vol = volume.back(); 
			// 区间收益率
			float return_now = close.back() / close.front();
			// 区间标准差
			float close_accum = 0.0;
			for_each(std::begin(close), std::end(close), [&](const float d) {
				close_accum += (d - close_m)*(d - close_m);
			});
			float stdev = sqrt(close_accum / (close.size() - 1));

			// 将计算出的指标添加到训练集X
			// features用于存放因子
			svm_node* features = new svm_node[7 + 1];
			features[0].index = 1;
			features[0].value = close_mean;
			features[1].index = 2;
			features[1].value = volume_mean;
			features[2].index = 3;
			features[2].value = max_mean;
			features[3].index = 4;
			features[3].value = min_mean;
			features[4].index = 5;
			features[4].value = vol;
			features[5].index = 6;
			features[5].value = return_now;
			features[6].index = 7;
			features[6].value = stdev;
			features[7].index = -1;
			prob.x[feature_i] = features;
			feature_i++;


			close.clear();
			max_x.clear();
			min_n.clear();
			amount.clear();
			volume.clear();


		}

		// 准备算法需要用到的数据
		int label = 0;
		for (int i = 0; i<days_close.size() - 20; i++)
		{
			if (days_close[i + 20] > days_close[i + 15])
			{
				label = 1;
			}
			else
			{
				label = 0;
			}

			prob.y[i] = label;
		}


		setParam();

		cout << "start training" << endl;
		svm_model *svmModel = svm_train(&prob, &param);
		cout << "save model" << endl;
		svm_save_model("svm_model", svmModel);
		cout << "done!" << endl;


		return;
	}

	void on_bar(Bar *bar)
	{
		long long bar_bob = bar->bob;
		char time_current[64];
		struct tm *tttime = new struct tm;

		localtime_s(tttime, &bar_bob);

		strftime(time_current, 64, "%Y-%m-%d %H:%M:%S", tttime);
		//获取上一个交易日
		char last_day[32] = { 0 };
		get_previous_trading_date("SHSE", time_current, last_day);

		// 获取数据并计算相应的因子
		// 于星期一的09:31 : 00进行操作
		// 当前bar的工作日
		int weekday = tttime->tm_wday;
		// 获取模型相关的数据
		// 获取持仓

		DataArray<Position>* pos = get_position();
		bool position = false;
		if (pos->status() == 0)
		{
			position = (pos->count() > 0) ? true : false;
		}
		pos->release();
		
		//如果bar是新的星期一且没有仓位则开始预测
		if (!position && weekday == 1)
		{
			//获取预测用的历史数据
			vector<float> close;
			vector<float> train_max_x;
			vector<float> train_min_n;
			vector<double> train_amount;
			vector<double> volume;
			DataArray<Bar>* data = history_bars_n(m_symbol, "1d", 15, last_day, 1, NULL, true, "Last");
			if (data->status() == 0)
			{
				for (int i = 0; i < data->count(); i++)
				{
					close.push_back(data->at(i).close);
					train_max_x.push_back(data->at(i).high);
					train_min_n.push_back(data->at(i).low);
					train_amount.push_back(data->at(i).amount);
					volume.push_back(train_amount[i] / close[i]);
				}
			}
			data->release();

			// 收盘价 / 均值
			float close_m = (accumulate(begin(close), end(close), 0.0) / close.size());
			float close_mean = close.back() / close_m;
			//cout << "mean: " << close_m << endl;
			// 现量/均量
			float volume_mean = volume.back() / (accumulate(begin(volume), end(volume), 0.0) / volume.size());
			// 最高价/均价
			float max_mean = train_max_x.back() / (accumulate(begin(train_max_x), end(train_max_x), 0.0) / train_max_x.size());
			// 最低价/均价
			float min_mean = train_min_n.back() / (accumulate(begin(train_min_n), end(train_min_n), 0.0) / train_min_n.size());
			// 现量
			double vol = volume.back();
			// 区间收益率
			float return_now = close.back() / close.front();
			// 区间标准差
			float close_accum = 0.0;
			for_each(std::begin(close), std::end(close), [&](const float d) {
				close_accum += (d - close_m)*(d - close_m);
			});
			float stdev = sqrt(close_accum / (close.size() - 1));


			//得到本次输入模型的因子
			svm_model *svmModel = svm_load_model("svm_model");
			svm_node* input = new svm_node[7 + 1];
			input[0].index = 1;
			input[0].value = close_mean;
			input[1].index = 2;
			input[1].value = volume_mean;
			input[2].index = 3;
			input[2].value = max_mean;
			input[3].index = 4;
			input[3].value = min_mean;
			input[4].index = 5;
			input[4].value = vol;
			input[5].index = 6;
			input[5].value = return_now;
			input[6].index = 7;
			input[6].value = stdev;
			input[7].index = -1;
			int predictValue = svm_predict(svmModel, input);

			//若预测值为上涨则开仓
			if (predictValue == 1)
			{
				m_price = close.back();
				//把浦发银行的仓位调至95%
				order_target_percent(m_symbol, 0.95, PositionSide_Long, OrderType_Market, 0, NULL);
				cout << m_symbol << "yi shi jia dan kai duo cang dao cang wei 0.95" << endl;

			}
			close.clear();
			train_max_x.clear();
			train_min_n.clear();
			train_amount.clear();
			volume.clear();

		}
		//当涨幅大于10%,平掉所有仓位止盈
		else if (position && bar->close / m_price >= 1.10)
		{
			order_close_all();
			cout << m_symbol << "yi shi jia dan quan ping duo cang zhi ying" << endl;
		}
		// 当时间为周五并且跌幅大于2%时,平掉所有仓位止损
		else if (position && bar->close / m_price < 1.02 && weekday == 5)
		{
			order_close_all();
			cout << m_symbol << "yi shi jia dan quan ping duo cang zhi sun" << endl;
		}
	}

private:
	const char* m_symbol;
	svm_parameter param;
	svm_problem prob;
	//int m_sampleNum;
	float m_price;


	void setParam()                // 设置svm相关系数
	{
		param.svm_type = C_SVC;

		param.kernel_type = RBF;

		param.degree = 3;

		param.gamma = 0.5;

		param.coef0 = 0;

		param.nu = 0.5;

		param.cache_size = 400;

		param.C = 1;

		param.eps = 0.001;

		param.p = 0.1;

		param.shrinking = 1;

		param.nr_weight = 0;

		param.weight = NULL;

		param.weight_label = NULL;
	}
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2017-08-01 09:00:00", "2017-09-05 09:00:00",
		10000000, 1, 0.0001, 0.0001, 1, 1);
	s.run();
	cout << "`press any key to exit!`" << endl;
	getchar();
	return 0;
}