//////////////////////////////////////////////////////////////////////////
//多个代码数据事件驱动
//策略描述：
//策略订阅多个代码数据，触发策略

#include <iostream>
#include "strategy.h"

using namespace std;

class MyStrategy :public Strategy
{
public:
	MyStrategy() {}
	~MyStrategy(){}

	//重写on_init事件，进行策略开发
	void on_init()
	{
		cout << "on_init" << endl;

		//订阅浦发银行, bar频率为一天
		subscribe("SHSE.600000,SZSE.000001", "1d");

		return;
	}

	void on_bar(Bar *bar)
	{
		cout << "代码:            " << bar->symbol << endl
			<< "bar的开始时间:   " << bar->bob << endl
			<< "bar的结束时间:   " << bar->eob << endl
			<< "开盘价:          " << bar->open << endl
			<< "收盘价:          " << bar->close << endl
			<< "最高价:          " << bar->high << endl
			<< "最低价:          " << bar->low << endl
			<< "成交量:          " << bar->volume << endl
			<< "成交金额:        " << bar->amount << endl
			<< "前收盘价:        " << bar->pre_close << endl
			<< "持仓量:          " << bar->position << endl
			<< "bar频度:         " << bar->frequency << endl;
	}
private:
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2016-07-11 17:20:00", "2017-07-11 17:30:00",
		1000000, 1, 0, 0, 0, 1);
	s.run();
	return 0;
}