//////////////////////////////////////////////////////////////////////////
//空策略

#include <iostream>
#include "strategy.h"
#include <time.h>
#include <string>
#include <vector>
#include <map>
#include <cmath>
#include<algorithm>
#include<math.h>

using namespace std;

class MyStrategy :public Strategy
{
public:
	MyStrategy()
	{
		//数据滑窗
		m_data = 20;
		//设置开仓的最大资金量
		m_ratio = 0.8;
		//账面市值比的大/中/小分类
		m_BM_BIG = 3.0;
		m_BM_MID = 2.0;
		m_BM_SMA = 1.0;
		//市值大/小分类
		m_MV_BIG = 2.0;
		m_MV_SMA = 1.0;
	}
	~MyStrategy(){}


	void on_init()
	{
		//每月第一个交易日的09:40 定时执行algo任务
		schedule("1m", "09:40:00");
		return;
	}

	//计算市值加权的收益率,MV为市值的分类,BM为账目市值比的分类
	double market_value_weighted(double MV, double BM)
	{
		long long mv_total = 0;
		double return_total = 0;
		for (int j = 0; j < mv_s.size(); j++)
		{
			if ((NEGOTIABLEMV_s[j] == MV) && (BM_s[j] == BM))
			{
				mv_total += mv_s[j];
			}
		}
		for (int i = 0; i < mv_s.size(); i++)
		{
			if ((NEGOTIABLEMV_s[i] == MV) && (BM_s[i] == BM))
			{
				return_total += (mv_total * return_s[i] != 0) ? mv_s[i] * return_s[i] / mv_total : 0;
			}
		}
		return return_total;
	}

	void on_schedule(const char *data_rule, const char *time_rule)
	{
		//获取上一个交易日的日期
		long long t = now();

		char time_now[64];

		struct tm *ttime = new struct tm;

		localtime_s(ttime, &t);

		strftime(time_now, 64, "%Y-%m-%d %H:%M:%S", ttime);
		cout << "time: " << time_now << endl;

		//获取上一个交易日
		char last_day[32] = { 0 };
		get_previous_trading_date("SHSE", time_now, last_day);

		//获取沪深300成份股
		DataSet* stock300 = get_constituents("SHSE.000300", last_day);
		//获取深沪300成分股标的代码
		string stock300_s = "";
		if (stock300->status() == 0)
		{
			while (!stock300->is_end())  //判断是否已经到达结果集末尾
			{
				stock300_s += stock300->get_string("symbol");
				stock300->next(); 
				if (!stock300->is_end())
				{
					stock300_s += ",";
				}
			}
		}
		else
		{
			cout << "get_constituents error: " << stock300->status() << endl;
		}
		const char *stock300_symbol = stock300_s.c_str();
		stock300->release();

		//获取当天有交易的股票
		DataSet* not_suspended_info = get_history_instruments(stock300_symbol, last_day, last_day);
		string not_suspended_s = "";

		if (not_suspended_info->status() == 0)
		{
			while (!not_suspended_info->is_end())  //判断是否已经到达结果集末尾
			{
				if (!not_suspended_info->get_integer("is_suspended"))
				{
					symbol_s.push_back(not_suspended_info->get_string("symbol"));
					not_suspended_s += not_suspended_info->get_string("symbol");
					not_suspended_s += ",";
				}
				not_suspended_info->next(); 
			}
			if (!not_suspended_s.empty() || not_suspended_s.back() == ',')
			{
				not_suspended_s.erase(not_suspended_s.size() - 1);
			}
		}
		else
		{
			// 调用get_history_instruments 失败
			cout << "get_history_instruments error: " << not_suspended_info->status() << endl;
		}
		const char *not_suspended = not_suspended_s.c_str();
		not_suspended_info->release();


		DataSet* fin = get_fundamentals("trading_derivative_indicator", not_suspended, last_day, last_day, "PB,NEGOTIABLEMV", NULL, NULL, 1000);
		map<string, double> symbol_pb;
		map<string, long long> symbol_NEGOTIABLEMV;
		vector<double> pb;
		vector<long long> negotiablemv;

		if (fin->status() == 0)
		{
			while (!fin->is_end())
			{
				//计算账面市值比,为P/B的倒数
				double p_b = pow(fin->get_real("PB"), (-1));
				pb.push_back(p_b);
				negotiablemv.push_back(fin->get_long_integer("NEGOTIABLEMV"));
				symbol_pb[fin->get_string("symbol")] = p_b;
				symbol_NEGOTIABLEMV[fin->get_string("symbol")] = fin->get_long_integer("NEGOTIABLEMV");
				fin->next();
			}
		}
		else
		{
			cout << "get_fundamentals error: " << fin->status() << endl;
		}
		fin->release();

		//计算市值的50%的分位点,用于后面的分类
		sort(pb.begin(), pb.end());
		sort(negotiablemv.begin(), negotiablemv.end());
		long long size_gate = 0;
		double mv_50 = (negotiablemv.size() - 1) * 0.5;
		size_gate = (mv_50 == (int)mv_50) ? negotiablemv[(int)mv_50] : negotiablemv[floor(mv_50)] + (negotiablemv[ceil(mv_50)] - negotiablemv[floor(mv_50)]) * (mv_50 - (int)mv_50);

		//计算账面市值比的30%和70%分位点,用于后面的分类
		double bm_gate[2] = { 0 };
		double bm_30 = (pb.size() - 1) * 0.3;
		bm_gate[0] = (bm_30 == (int)bm_30) ? pb[(int)bm_30] : pb[floor(bm_30)] + (pb[ceil(bm_30)] - pb[floor(bm_30)]) * (bm_30 - (int)bm_30);

		double bm_70 = (pb.size() - 1) * 0.7;
		bm_gate[1] = (bm_70 == (int)bm_70) ? pb[(int)bm_70] : pb[floor(bm_70)] + (pb[ceil(bm_70)] - pb[floor(bm_70)]) * (bm_70 - (int)bm_70);



		//对未停牌的股票进行处理
		for (int i = 0; i < symbol_s.size(); i++)
		{
			//计算收益率
			DataArray<Bar>* his_bars = history_bars_n(symbol_s[i].c_str(), "1d", m_data + 1, last_day, 1, NULL, true, "Last");
			double stock_return = 0;
			if (his_bars->status() == 0)
			{
				for (int i = 0; i < his_bars->count(); i++)
				{
					if (i == 0)
					{
						stock_return = his_bars->at(i).close;
					}
					if (i == his_bars->count() - 1)
					{
						stock_return = his_bars->at(i).close / stock_return - 1;
					}
				}
			}
			his_bars->release();
			double pb = 0;
			if (symbol_pb.find(symbol_s[i]) != symbol_pb.end())
			{
				pb = symbol_pb.find(symbol_s[i])->second;
			}
			long long market_value = 0;
			if (symbol_NEGOTIABLEMV.find(symbol_s[i]) != symbol_NEGOTIABLEMV.end())
			{
				market_value = symbol_NEGOTIABLEMV.find(symbol_s[i])->second;
			}
			//获取[股票代码. 股票收益率, 账面市值比的分类, 市值的分类, 流通市值]
			if (pb < bm_gate[0])
			{
				if (market_value < size_gate)
				{
					//cout << symbol_s[i] << " " << stock_return << " " << m_BM_SMA << " " << m_MV_SMA << " " << market_value << endl;
					return_s.push_back(stock_return);
					BM_s.push_back(m_BM_SMA);
					NEGOTIABLEMV_s.push_back(m_MV_SMA);
					mv_s.push_back(market_value);
				}
				else
				{
					//cout << symbol_s[i] << " " << stock_return << " " << m_BM_SMA << " " << m_MV_BIG << " " << market_value << endl;
					return_s.push_back(stock_return);
					BM_s.push_back(m_BM_SMA);
					NEGOTIABLEMV_s.push_back(m_MV_BIG);
					mv_s.push_back(market_value);
				}
			}
			else if (pb < bm_gate[1])
			{
				if (market_value < size_gate)
				{
					//cout << symbol_s[i] << " " << stock_return << " " << m_BM_MID << " " << m_MV_SMA << " " << market_value << endl;
					return_s.push_back(stock_return);
					BM_s.push_back(m_BM_MID);
					NEGOTIABLEMV_s.push_back(m_MV_SMA);
					mv_s.push_back(market_value);
				}
				else
				{
					//cout << symbol_s[i] << " " << stock_return << " " << m_BM_MID << " " << m_MV_BIG << " " << market_value << endl;
					return_s.push_back(stock_return);
					BM_s.push_back(m_BM_MID);
					NEGOTIABLEMV_s.push_back(m_MV_BIG);
					mv_s.push_back(market_value);
				}
			}
			else if (market_value < size_gate)
			{
				//cout << symbol_s[i] << " " << stock_return << " " << m_BM_BIG << " " << m_MV_SMA << " " << market_value << endl;
				return_s.push_back(stock_return);
				BM_s.push_back(m_BM_BIG);
				NEGOTIABLEMV_s.push_back(m_MV_SMA);
				mv_s.push_back(market_value);
			}
			else
			{
				//cout << symbol_s[i] << " " << stock_return << " " << m_BM_BIG << " " << m_MV_BIG << " " << market_value << endl;
				return_s.push_back(stock_return);
				BM_s.push_back(m_BM_BIG);
				NEGOTIABLEMV_s.push_back(m_MV_BIG);
				mv_s.push_back(market_value);
			}
		}
		//计算SMB.HML和市场收益率
		//获取小市值组合的市值加权组合收益率
		double smb_s = (market_value_weighted(m_MV_SMA, m_BM_SMA) + market_value_weighted(m_MV_SMA, m_BM_MID) + market_value_weighted(m_MV_SMA, m_BM_BIG)) / 3;
		//获取大市值组合的市值加权组合收益率
		double smb_b = (market_value_weighted(m_MV_BIG, m_BM_SMA) + market_value_weighted(m_MV_BIG, m_BM_MID) + market_value_weighted(m_MV_BIG, m_BM_BIG)) / 3;
		double smb = smb_s - smb_b;
		//获取大账面市值比组合的市值加权组合收益率
		double hml_b = (market_value_weighted(m_MV_SMA, m_BM_BIG) + market_value_weighted(m_MV_BIG, m_BM_BIG)) / 2;
		//获取小账面市值比组合的市值加权组合收益率
		double hml_s = (market_value_weighted(m_MV_SMA, m_BM_SMA) + market_value_weighted(m_MV_BIG, m_BM_SMA)) / 2;
		double hml = hml_b - hml_s;
		//cout << "smb: " << smb << "hml: " << hml << endl;
		DataArray<Bar>* his_bars = history_bars_n("SHSE.000300", "1d", m_data + 1, last_day, 1, NULL, true, "Last");
		double market_return = 0;
		if (his_bars->status() == 0)
		{
			for (int i = 0; i < his_bars->count(); i++)
			{
				if (i == 0)
				{
					market_return = his_bars->at(i).close;
				}
				if (i == his_bars->count() - 1)
				{
					market_return = his_bars->at(i).close / market_return - 1;
				}
			}
		}
		his_bars->release();


		vector<int> symbol_v(10);
		vector<double> return_v(10, 10);


		for (int i = 0; i < return_s.size(); i++)
		{
			if (return_s[i] < 0 && return_s[i] < return_v.back())
			{
				if (symbol_s[i] == "SZSE.300033")
				{
					cout << "hey!!!!!!!!!!" << endl;
				}
				return_v.pop_back();
				return_v.push_back(return_s[i]);
				sort(return_v.begin(), return_v.end());
				int idx = 0;
				for (int j = 0; j < return_v.size(); j++)
				{
					if (return_v[j] == return_s[i])
					{
						idx = j;
						break;
					}
				}
				symbol_v.pop_back();
				symbol_v.insert(symbol_v.begin() + idx, i);
			}
		}
		vector<string> symbols_pool;
		for (int i = 0; i < 10; i++)
		{
			symbols_pool.push_back(symbol_s[symbol_v[i]]);
		}


		//平不在标的池的股票
		DataArray<Position> *positions = get_position();

		if (positions->status() == 0)
		{
			for (int i = 0; i < positions->count(); i++)
			{
				string sym = positions->at(i).symbol;
				if (find(symbols_pool.begin(), symbols_pool.end(), sym) == symbols_pool.end())
				{
					order_target_percent(sym.c_str(), 0, PositionSide_Long, OrderType_Market);
					cout << "shi jia dan ping bu zai biao de chi de " << sym << endl;
				}
			}
		}
		positions->release();

		//获取股票的权重
		double percent = m_ratio / symbols_pool.size();
		//买在标的池中的股票
		for (string symb : symbols_pool)
		{
			order_target_percent(symb.c_str(), percent, PositionSide_Long, OrderType_Market);
			cout << symb << " yi shi jia dan tiao duo cang dao cang wei " << percent << endl;
		}

		symbol_s.clear();
		return_s.clear();
		BM_s.clear();
		NEGOTIABLEMV_s.clear();
		mv_s.clear();
		symbol_v.clear();
		return_v.clear();
		symbols_pool.clear();
		pb.clear();
		negotiablemv.clear();
		symbol_pb.clear();
		symbol_NEGOTIABLEMV.clear();


	}

private:
	int m_data;
	double m_ratio;
	double m_BM_BIG;
	double m_BM_MID;
	double m_BM_SMA;
	double m_MV_BIG;
	double m_MV_SMA;
	vector<double>return_s;
	vector<double>BM_s;
	vector<double>NEGOTIABLEMV_s;
	vector <long long> mv_s;
	vector<string> symbol_s;

};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	s.set_mode(MODE_BACKTEST);
	s.set_backtest_config("2017-07-01 08:00:00", "2017-10-01 16:00:00",
		10000000, 1, 0.0001, 0.0001, 1, 1);
	s.run();
	cout << "`press any key to exit!`" << endl;
	getchar();
	return 0;
}
