//////////////////////////////////////////////////////////////////////////
//模式选择
//策略描述：
//策略支持两种运行模式，实时模式和回测模式，用户需要在运行策略时选择模式，执行run函数时mode=1 表示回测模式，mode=0表示实时模式

#include <iostream>
#include "strategy.h"

using namespace std;

class MyStrategy :public Strategy
{
public:
	MyStrategy() {}
	~MyStrategy(){}

	//重写on_init事件，进行策略开发
	void on_init()
	{
		cout << "on_init" << endl;
		subscribe("SHSE.600000", "tick");

		return;
	}

	void on_tick(Tick *tick)
	{
		cout << "代码:                        " << tick->symbol << endl
			<< "utc时间，精确到毫秒:          " << tick->created_at << endl
			<< "最新价:                       " << tick->price << endl
			<< "开盘价:                       " << tick->open << endl
			<< "最高价:                       " << tick->high << endl
			<< "最低价:                       " << tick->low << endl
			<< "成交总量                      " << tick->cum_volume << endl
			<< "成交总金额/最新成交额,累计值: " << tick->cum_amount << endl
			<< "合约持仓量(期),累计值:        " << tick->cum_position << endl
			<< "瞬时成交额:                   " << tick->last_amount << endl
			<< "瞬时成交量:                   " << tick->last_volume << endl
			<< "交易类型,对应多开,多平等类型: " << tick->trade_type << endl;
	}

private:
};

int main(int argc, char *argv[])
{
	MyStrategy s;
	s.set_strategy_id("{{strategyId}}");
	s.set_token("{{token}}");
	// mode = MODE_LIVE  // 实时模式
	// mode = MODE_BACKTEST  // 回测模式, 指定回测开始时间backtest_start_time和结束时间backtest_end_time
	//s.set_backtest_config("2016-07-11 17:20:00", "2017-07-11 17:30:00",1000000, 1, 0, 0, 0, 1);  //回测模式需调用此函数

	s.set_mode(MODE_LIVE);

	s.run();
	return 0;
}