#ifndef GMCPPSDK_H
#define GMCPPSDK_H

#include <iostream>
#include "gmdef.h"

#ifdef WIN32
#ifdef GMSDKC_EXPORTS  
#define GM_CXX_API __declspec(dllexport)
#else
#define GM_CXX_API __declspec(dllimport)
#endif
#else
#define GM_CXX_API
#endif

//
class DataSet
{
public:
	//ȡapiý, 0: ɹ 0: 
	virtual int status() = 0;

	//status() != 0 ʱشϢ, utf-8
	virtual const char* errer_msg() = 0;

	//жǷѾǵĩβ
	virtual bool is_end() = 0;

	//Ƶһ¼
	virtual void next() = 0;

	//ȡֵ
	virtual int get_integer(const char *key) = 0;

	//ȡֵ
	virtual long long get_long_integer(const char *key) = 0;

	//ȡֵ
	virtual double get_real(const char *key) = 0;

	//ȡֵַ
	virtual const char* get_string(const char *key) = 0;

	//ͷݼ
	virtual void release() = 0;

	//ӡ
	virtual const char* debug_string() = 0;
};

//
template <typename T>
class DataArray
{
public:
	//ȡapiý, 0: ɹ 0: 
	virtual int status() = 0;

	//status() != 0 ʱشϢ, utf-8
	virtual const char* errer_msg() = 0;

	//ؽṹָ
	virtual T* data() = 0;

	//ݵĳ
	virtual int count() = 0;

	//±ΪiĽṹã0ʼ
	virtual T& at(int i) = 0;

	//ͷݼ
	virtual void release() = 0;
};

// ȡsdk汾
GM_CXX_API const char* get_version();

// token
GM_CXX_API void set_token(const char *token);

// Զַ
GM_CXX_API void set_serv_addr(const char *addr);

// Զַv5汾
GM_CXX_API void set_serv_addr_v5(const char *addr, const char *orgcode, const char *site_id);

// ûز߳[1-32]
GM_CXX_API void set_backtest_threadnum(int n);

// ctpϢ
GM_CXX_API void set_ctp_md_info(const char *front_addresses, const char *user_name = NULL, const char *password = NULL);

//ϵͳϢ
GM_CXX_API void set_mfp(const char *mfp);

GM_CXX_API void set_simtrade_only();

GM_CXX_API void set_account_id(const char *account_ids);


//ߺ

//gbkַתutf8ַ
GM_CXX_API char * gbk2utf(const char *gbk);

//utf8ַתgbkַ
GM_CXX_API char * utf2gbk(const char *utf8);

// ѯǰ
GM_CXX_API DataArray<Tick>* current(const char *symbols, bool include_call_auction = false);

// ѯǰ¼
GM_CXX_API DataArray<LatestPrice>* current_price(const char *symbols);

// ѯǰգ
GM_CXX_API DataArray<Tick>* last_tick(const char *symbols, bool include_call_auction = false);

// ѯʷTick
GM_CXX_API DataArray<Tick>* history_ticks(const char *symbols, const char *start_time, const char *end_time, int adjust = 0, const char *adjust_end_time = NULL, bool skip_suspended = true, const char *fill_missing = NULL);

// ѯʷBar
GM_CXX_API DataArray<Bar>* history_bars(const char *symbols, const char *frequency, const char *start_time, const char *end_time, int adjust = 0, const char *adjust_end_time = NULL, bool skip_suspended = true, const char *fill_missing = NULL);

// ѯnTick
GM_CXX_API DataArray<Tick>* history_ticks_n(const char *symbols, int n, const char *end_time = NULL, int adjust = 0, const char *adjust_end_time = NULL, bool skip_suspended = true, const char *fill_missing = NULL);

//ѯnBar
GM_CXX_API DataArray<Bar>* history_bars_n(const char *symbols, const char *frequency, int n, const char *end_time = NULL, int adjust = 0, const char *adjust_end_time = NULL, bool skip_suspended = true, const char *fill_missing = NULL);

// ѯʷL2 Tick
GM_CXX_API DataArray<Tick>* history_l2ticks(const char *symbols, const char *start_time, const char *end_time, int adjust = 0, const char *adjust_end_time = NULL, bool skip_suspended = true, const char *fill_missing = NULL);

// ѯʷL2 Bar
GM_CXX_API DataArray<Bar>* history_l2bars(const char *symbols, const char *frequency, const char *start_time, const char *end_time, int adjust = 0, const char *adjust_end_time = NULL, bool skip_suspended = true, const char *fill_missing = NULL);

// ѯʷL2 ʳɽ
GM_CXX_API DataArray<L2Transaction>* history_l2transactions(const char *symbols, const char *start_time, const char *end_time);

// ѯʷL2 ί
GM_CXX_API DataArray<L2Order>* history_l2orders(const char *symbols, const char *start_time, const char *end_time);

// ѯʷL2 ίж(ż50ί)
GM_CXX_API DataArray<L2OrderQueue>* history_l2orders_queue(const char *symbols, const char *start_time, const char *end_time);

// ѯ
GM_CXX_API DataSet* get_fundamentals(const char *table, const char *symbols, const char *start_date, const char *end_date, const char *fields, const char *filter = NULL, const char *order_by = NULL, int limit = 1000);

// ѯn
GM_CXX_API DataSet* get_fundamentals_n(const char *table, const char *symbols, const char *end_date, const char *fields, int n = 1, const char *filter = NULL, const char * order_by = NULL);

// ѯ½ױϢ
GM_CXX_API DataSet* get_instruments(const char *exchanges = NULL, const char *sec_types = NULL, const char* fields = NULL);

// ѯױʷ
GM_CXX_API DataSet* get_history_instruments(const char *symbols, const char *start_date, const char *end_date, const char *fields = NULL);

// ѯױĻϢ
GM_CXX_API DataSet* get_instrumentinfos(const char *symbols = NULL, const char *exchanges = NULL, const char * sec_types = NULL, const char *names = NULL, const char *fields = NULL);

// ѯָɷݹ
GM_CXX_API DataSet* get_constituents(const char *index, const char *trade_date = NULL);

// ѯҵƱб
GM_CXX_API DataArray<Symbol>* get_industry(const char *code);

// ѯƱб
GM_CXX_API DataArray<Symbol>* get_concept(const char *code);

// ѯб
GM_CXX_API DataArray<TradingDate>* get_trading_dates(const char *exchange, const char *start_date, const char *end_date);

// ָڵһ
GM_CXX_API int get_previous_trading_date(const char *exchange, const char *date, char *output_date);

// ָڵһ
GM_CXX_API int get_next_trading_date(const char *exchange, const char *date, char *output_date);

// ѯֺ
GM_CXX_API DataSet* get_dividend(const char *symbol, const char *start_date, const char *end_date);

// ȡԼ
GM_CXX_API DataSet* get_continuous_contracts(const char *csymbol, const char *start_date, const char *end_date);

// ѯѯƷϢ
GM_CXX_API DataArray<VarietyInfo>* get_varietyinfos(const char *variety_names);

// ѯʱ
GM_CXX_API DataArray<TradingTimes>* get_trading_time(const char *variety_names);

// ѯȨԼ
GM_CXX_API DataArray<Symbol>* option_get_symbols_by_exchange(const char *exchange = NULL, const char *trade_date = NULL, const char *call_or_put = NULL);

// ѯʵƽֵĳԼ
GM_CXX_API DataArray<Symbol>* option_get_symbols_by_in_at_out(const char *underlying_symbol = NULL, const char *trade_date = NULL, int excute_month = 0, const char *call_or_put = NULL, int in_at_out = IN_AT_OUT_NO_SPECIFIED, const char *price_type = NULL, double price = -1);

// ѯȨб
GM_CXX_API DataArray<TradingDate>* option_get_delisted_dates(const char *underlying_symbol = NULL, const char *trade_date = NULL, int excute_month = 0);

// ѯȨȨб
GM_CXX_API DataArray<double>* option_get_exercise_prices(const char *underlying_symbol = NULL, const char *trade_date = NULL, int excute_month = 0, const char *adjust_flag = NULL);


/*************************************************************** ݺ  **************************************************************************/

//ͨû

//ѯĻϢ
GM_CXX_API DataArray<SymbolInfo>* get_symbol_infos(long long sec_type1, long long sec_type2 = 0, const char *exchanges = NULL, const char *symbols = NULL);
//ѯָնĽϢ
GM_CXX_API DataArray<SymbolContent>* get_symbols_by_date(long long sec_type1, long long sec_type2 = 0, const char *exchanges = NULL, const char *symbols = NULL, bool skip_suspended = true, bool skip_st = true, const char *trade_date = NULL);
//ѯָĶսϢ
GM_CXX_API DataArray<SymbolContent>* get_history_symbol(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯȽ
GM_CXX_API DataArray<TradingDateContent>* get_trading_dates_by_year(const char *exchange, int start_year, int end_year);
//ѯָڵǰn
GM_CXX_API DataArray<TradingDate>* get_previous_n_trading_dates(const char *exchange, const char *date, int n);
//ѯָڵĺn
GM_CXX_API DataArray<TradingDate>* get_next_n_trading_dates(const char *exchange, const char *date, int n);

//ѯʱ
GM_CXX_API DataArray<TradingSession>* get_trading_session(const char *symbols);
// - ѯԼʣ
GM_CXX_API DataArray<ContractExpireRestDays>* get_contract_expire_rest_days(const char *symbols, const char *start_date, const char *end_date, bool trade_flag = false);
// - ѯ̼Ͼ۳ɽ
GM_CXX_API DataArray<Tick>* get_open_call_auction(const char *symbols, const char *trade_date = NULL);

//Ʊ

//ѯҵ
GM_CXX_API DataArray<StkIndustryCategory>* stk_get_industry_category(const char *source = NULL, int level = 0);
//ѯҵɷֹ
GM_CXX_API DataArray<StkIndustryConstituent>* stk_get_industry_constituents(const char *industry_code, const char *date = NULL);
//ѯƱҵ
GM_CXX_API DataArray<StkSymbolIndustry>* stk_get_symbol_industry(const char *symbols, const char *source = NULL, int level = 0, const char *date = NULL);
// - ѯ
GM_CXX_API DataArray<StkSectorCategory>* stk_get_sector_category(const char *sector_type);
// - ѯɷֹ
GM_CXX_API DataArray<StkSectorConstituent>* stk_get_sector_constituents(const char *sector_code);
// - ѯƱ
GM_CXX_API DataArray<StkSymbolSector>* stk_get_symbol_sector(const char *symbols, const char *sector_type);

//ѯָ³ɷֹ 
GM_CXX_API DataArray<StkIndexConstituent>* stk_get_index_constituents(const char *symbol, const char *trade_date = NULL);
//ѯƱֺ͹Ϣ
GM_CXX_API DataArray<StkDividend>* stk_get_dividend(const char *symbol, const char *start_date, const char *end_date);
// - ѯƱϢ
GM_CXX_API DataArray<StkRation>* stk_get_ration(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);

//ѯƱĸȨ
GM_CXX_API DataArray<StkAdjFactor>* stk_get_adj_factor(const char *symbol, const char *start_date = NULL, const char *end_date = NULL, const char *base_date = NULL);
// - ѯɶ
GM_CXX_API DataArray<StkShareholderNum>* stk_get_shareholder_num(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
// - ѯʮɶ
GM_CXX_API DataArray<StkShareholder>* stk_get_top_shareholder(const char *symbol, const char *start_date = NULL, const char *end_date = NULL, bool tradable_holder = false);
// - ѯɱ䶯
GM_CXX_API DataArray<StkShareChange>* stk_get_share_change(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);

// - ѯʲծ
GM_CXX_API DataSet* stk_get_fundamentals_balance(const char *symbol, const char *fields, int rpt_type = 0, int data_type = 0, const char *start_date = NULL, const char *end_date = NULL);
//  - ѯֽ
GM_CXX_API DataSet* stk_get_fundamentals_cashflow(const char *symbol, const char *fields, int rpt_type = 0, int data_type = 0, const char *start_date = NULL, const char *end_date = NULL);
//  - ѯ
GM_CXX_API DataSet* stk_get_fundamentals_income(const char *symbol, const char *fields, int rpt_type = 0, int data_type = 0, const char *start_date = NULL, const char *end_date = NULL);
// - ѯʲծ
GM_CXX_API DataSet* stk_get_fundamentals_balance_pt(const char *symbols, const char *fields, int rpt_type = 0, int data_type = 0, const char *date = NULL);
// - ѯֽ
GM_CXX_API DataSet* stk_get_fundamentals_cashflow_pt(const char *symbols, const char *fields, int rpt_type = 0, int data_type = 0, const char *date = NULL);
// - ѯ
GM_CXX_API DataSet* stk_get_fundamentals_income_pt(const char *symbols, const char *fields, int rpt_type = 0, int data_type = 0, const char *date = NULL);

// - ѯҪָ
GM_CXX_API DataSet* stk_get_finance_prime(const char *symbol, const char *fields, int rpt_type = 0, int data_type = 0, const char *start_date = NULL, const char *end_date = NULL);
// - ѯָ
GM_CXX_API DataSet* stk_get_finance_deriv(const char *symbol, const char *fields, int rpt_type = 0, int data_type = 0, const char *start_date = NULL, const char *end_date = NULL);
// - ѯֵָÿ
GM_CXX_API DataSet* stk_get_daily_valuation(const char *symbol, const char *fields, const char *start_date = NULL, const char *end_date = NULL);
// - ѯֵָÿ
GM_CXX_API DataSet* stk_get_daily_mktvalue(const char *symbol, const char *fields, const char *start_date = NULL, const char *end_date = NULL);
// - ѯָÿ
GM_CXX_API DataSet* stk_get_daily_basic(const char *symbol, const char *fields, const char *start_date = NULL, const char *end_date = NULL);

// - ѯҪָ
GM_CXX_API DataSet* stk_get_finance_prime_pt(const char *symbols, const char *fields, int rpt_type = 0, int data_type = 0, const char *date = NULL);
// - ѯָ
GM_CXX_API DataSet* stk_get_finance_deriv_pt(const char *symbols, const char *fields, int rpt_type = 0, int data_type = 0, const char *date = NULL);
// - ѯֵָ굥ս
GM_CXX_API DataSet* stk_get_daily_valuation_pt(const char *symbols, const char *fields, const char *trade_date = NULL);
// - ѯֵָ굥ս
GM_CXX_API DataSet* stk_get_daily_mktvalue_pt(const char *symbols, const char *fields, const char *trade_date = NULL);
// - ѯָ굥ս
GM_CXX_API DataSet* stk_get_daily_basic_pt(const char *symbols, const char *fields, const char *trade_date = NULL);

// - ѯƱ
GM_CXX_API DataArray<StkAbnorChangeStocks>* stk_abnor_change_stocks(const char *symbols = NULL, const char *change_types = NULL, const char *trade_date = NULL);
// - ѯӪҵ
GM_CXX_API DataArray<StkAbnorChangeDetail>* stk_abnor_change_detail(const char *symbols = NULL, const char *change_types = NULL, const char *trade_date = NULL);
// - ѯͨ
GM_CXX_API DataArray<StkQuotaShszhkInfos>* stk_quota_shszhk_infos(const char *types = NULL, const char *start_date = NULL, const char *end_date = NULL, int count = 0);
// - ѯͨĸ۹ɻֹϸ
GM_CXX_API DataArray<StkHkInstHoldingDetailInfo>* stk_hk_inst_holding_detail_info(const char *symbols = NULL, const char *trade_date = NULL);
// - ѯͨĸ۹ɻֹ
GM_CXX_API DataArray<StkHkInstHoldingInfo>* stk_hk_inst_holding_info(const char *symbols = NULL, const char *trade_date = NULL);
// - ѯͨʮԾɽ
GM_CXX_API DataArray<StkActiveStockTop10ShszhkInfo>* stk_active_stock_top10_shszhk_info(const char *types = NULL, const char *trade_date = NULL);
// - ѯƱʽ
GM_CXX_API DataArray<StkMoneyFlowRecord>* stk_get_money_flow(const char *symbols, const char *trade_date = NULL);
// - ѯ
GM_CXX_API DataArray<StkFinanceAuditRecord>* stk_get_finance_audit(const char *symbols, const char *date = NULL, const char *rpt_date = NULL);
// - ѯ˾ҵԤ
GM_CXX_API DataArray<StkFinanceForecastRecord>* stk_get_finance_forecast(const char *symbols, const char *rpt_type = NULL, const char *date = NULL);


//ڻ

//ѯԼӦʵԼ 
GM_CXX_API DataArray<FutContinuousContractsInfo>* fut_get_continuous_contracts(const char *csymbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯڻ׼ƷϢ
GM_CXX_API DataArray<FutContractInfo>* fut_get_contract_info(const char *product_codes);
//ѯڻÿճɽֲ
GM_CXX_API DataArray<FutTransactionRanking>* fut_get_transaction_ranking(const char *symbol, const char *trade_date, const char *indicator = NULL);
//ѯڻÿճɽֲ(룬ָ)
GM_CXX_API DataArray<FutTransactionRankings>* fut_get_transaction_rankings(const char *symbols, const char *trade_date, const char *indicators = NULL);
//ѯڻֵ
GM_CXX_API DataArray<FutWarehouseReceiptInfo>* fut_get_warehouse_receipt(const char *product_code, const char *start_date = NULL, const char *end_date = NULL);


//

//ѯETF³ɷֹ
GM_CXX_API DataArray<FndEtfConstituents>* fnd_get_etf_constituents(const char *symbol);
//ѯʲ(ƱͶ)
GM_CXX_API DataArray<FndPortfolioStockInfo>* fnd_get_stock_portfolio(const char *symbol, int report_type, const char *start_date = NULL, const char *end_date = NULL);
//ѯʲ(ծȯͶ)
GM_CXX_API DataArray<FndPortfolioBondInfo>* fnd_get_bond_portfolio(const char *symbol, int report_type, const char *start_date = NULL, const char *end_date = NULL);
//ѯʲ(Ͷ)
GM_CXX_API DataArray<FndPortfolioFundInfo>* fnd_get_fund_portfolio(const char *symbol, int report_type, const char *start_date = NULL, const char *end_date = NULL);
//ѯֵ
GM_CXX_API DataArray<FndNetValueInfo>* fnd_get_net_value(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯȨ
GM_CXX_API DataArray<FndAdjFactorInfo>* fnd_get_adj_factor(const char *symbol, const char *start_date = NULL, const char *end_date = NULL, const char *base_date = NULL);
//ѯֺϢ
GM_CXX_API DataArray<FndDividendInfo>* fnd_get_dividend(const char *symbol, const char *start_date, const char *end_date);
//ѯϢ
GM_CXX_API DataArray<FndSplitInfo>* fnd_get_split(const char *symbol, const char *start_date, const char *end_date);
//ѯģ
GM_CXX_API DataArray<FndShareRecord>* fnd_get_share(const char *fund, const char *start_date = NULL, const char *end_date = NULL);


//ծȯ

//ѯתծתɼ۱䶯Ϣ
GM_CXX_API DataArray<BndConversionPrice>* bnd_get_conversion_price(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯתծϢ
GM_CXX_API DataArray<BndCallInfo>* bnd_get_call_info(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯתծϢ
GM_CXX_API DataArray<BndPutInfo>* bnd_get_put_info(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯתծʣģ䶯
GM_CXX_API DataArray<BndAmountChange>* bnd_get_amount_change(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);
//ѯתծָ
GM_CXX_API DataArray<BndAnalysisRecord>* bnd_get_analysis(const char *symbol, const char *start_date = NULL, const char *end_date = NULL);


//ĳ

//ñĳ
GM_CXX_API int universe_set(const char *universe_name, const char *universe_symbols);

//ɾĳ
GM_CXX_API int universe_delete(const char *universe_name);

//ȡĳسɷ
GM_CXX_API DataArray<Symbol>* universe_get_symbols(const char *universe_name);

//ȡȫĳ 
GM_CXX_API DataArray<GmName>* universe_get_names();

#endif
