#ifndef GMCSDK_DEF_H
#define GMCSDK_DEF_H


const unsigned int LEN_ID = 64;
const unsigned int LEN_NAME = 64;
const unsigned int LEN_SYMBOL = 32;
const unsigned int LEN_INFO = 128;
const unsigned int LEN_EXCHANGE = 8;
const unsigned int LEN_ISO_DATATIME = 36;
const unsigned int LEN_FREQUENCY = 8;
const unsigned int DEPTH_OF_QUOTE = 10;
const unsigned int LEN_PARAM = 256;
const unsigned int LEN_COMMENT = 256;
const unsigned int LEN_MAX_ORDER_QUEUE = 50;
const unsigned int LEN_TYPE = 8;
const unsigned int LEN_LONG_TYPE = 32;
const unsigned int LEN_TIME_LIST = 128;
const unsigned int LEN_TEXT = 65536;
const unsigned int MAX_TRADING_SESSION_NUM = 5;

#define IN_AT_OUT_NO_SPECIFIED 2147483647

enum StrategyMode
{
	MODE_UNDEF = 0,          //δ壬 Բ
	MODE_LIVE = 1,           //ʵģʽ
	MODE_BACKTEST = 2        //زģʽ
};

enum OrderStatus
{
	OrderStatus_Unknown = 0,
	OrderStatus_New = 1,                   //ѱ
	OrderStatus_PartiallyFilled = 2,       //
	OrderStatus_Filled = 3,                //ѳ
	OrderStatus_DoneForDay = 4,            //
	OrderStatus_Canceled = 5,              //ѳ
	OrderStatus_PendingCancel = 6,         //
	OrderStatus_Stopped = 7,               //
	OrderStatus_Rejected = 8,              //Ѿܾ
	OrderStatus_Suspended = 9,             //
	OrderStatus_PendingNew = 10,           //
	OrderStatus_Calculated = 11,           //
	OrderStatus_Expired = 12,              //ѹ
	OrderStatus_AcceptedForBidding = 13,   //
	OrderStatus_PendingReplace = 14,       //
	OrderStatus_PendingTrigger = 15,       //, CTP
	OrderStatus_Triggered = 16             //Ѵ, CTP
};

//ִлر
enum ExecType
{
	ExecType_Unknown = 0,
	ExecType_New = 1,                      //ѱ
	ExecType_DoneForDay = 4,               //
	ExecType_Canceled = 5,                 //ѳ
	ExecType_PendingCancel = 6,            //
	ExecType_Stopped = 7,                  //
	ExecType_Rejected = 8,                 //Ѿܾ
	ExecType_Suspended = 9,                //
	ExecType_PendingNew = 10,              //
	ExecType_Calculated = 11,              //
	ExecType_Expired = 12,                 //
	ExecType_Restated = 13,                //
	ExecType_PendingReplace = 14,          //
	ExecType_Trade = 15,                   //ɽ
	ExecType_TradeCorrect = 16,            //
	ExecType_TradeCancel = 17,             //
	ExecType_OrderStatus = 18,             //ί״̬
	ExecType_CancelRejected = 19,          //ܾ
};

//ίоܾԭ
enum OrderRejectReason
{
	OrderRejectReason_Unknown = 0,                           //δ֪ԭ
	OrderRejectReason_RiskRuleCheckFailed = 1,               //Ϸع 
	OrderRejectReason_NoEnoughCash = 2,                      //ʽ
	OrderRejectReason_NoEnoughPosition = 3,                  //λ
	OrderRejectReason_IllegalAccountId = 4,                  //Ƿ˻ID
	OrderRejectReason_IllegalStrategyId = 5,                 //ǷID
	OrderRejectReason_IllegalSymbol = 6,                     //Ƿ״
	OrderRejectReason_IllegalVolume = 7,                     //Ƿί
	OrderRejectReason_IllegalPrice = 8,                      //Ƿίм
	OrderRejectReason_AccountDisabled = 10,                  //˺űֹ
	OrderRejectReason_AccountDisconnected = 11,              //˺δ
	OrderRejectReason_AccountLoggedout = 12,                 //˺δ¼
	OrderRejectReason_NotInTradingSession = 13,              //ǽʱ
	OrderRejectReason_OrderTypeNotSupported = 14,            //ίͲ֧
	OrderRejectReason_Throttle = 15,                         //
	OrderRejectReason_SymbolSusppended = 16,                 //״ͣ
	OrderRejectReason_Internal = 999,                        //ڲ

	CancelOrderRejectReason_OrderFinalized = 101,            //ί
	CancelOrderRejectReason_UnknownOrder = 102,              //δ֪ί
	CancelOrderRejectReason_BrokerOption = 103,              //̨
	CancelOrderRejectReason_AlreadyInPendingCancel = 104,    //ίг
};

//ίз
enum OrderSide
{
	OrderSide_Unknown = 0,
	OrderSide_Buy = 1,    //
	OrderSide_Sell = 2,    //
};

//ί
enum OrderType
{
	OrderType_Unknown = 0,
	OrderType_Limit = 1,        //޼ί
	OrderType_Limit_FAK = 10,   //޼FAK
	OrderType_Limit_FOK = 11,   //޼FOK

	OrderType_Market = 2,       //мί
	OrderType_Market_BOC = 20,  //м۶Էż۸(best of counterparty)
	OrderType_Market_BOP = 21,  //мۼż۸(best of party)
	OrderType_Market_FAK = 22,  //мۼʱɽʣ೷(fill and kill)
	OrderType_Market_FOK = 23,  //мۼʱȫɽ(fill or kill)
	OrderType_Market_B5TC = 24, //м嵵ʣ೷(best 5 then cancel)
	OrderType_Market_B5TL = 25, //м嵵ʣת޼(best 5 then limit)
	OrderType_Market_FAL = 26,  //мʣת޼(fill and limit)
	OrderType_Market_BOPC = 27, //мż۳ɽʣ೷(best of price fill and kill)
	OrderType_Market_BOPL = 28, //мż۳ɽʣ೷(best of price then limit)

	OrderType_Limit_Stop = 30,       //޼ֹ
	OrderType_Limit_StopPrift = 31,  //޼ֹӯ
	OrderType_Market_Stop = 32,      //мֹ
	OrderType_Market_StopProfit = 33 //мֹӯ
};

//ίʱ
enum OrderDuration
{
	OrderDuration_Unknown = 0,
	OrderDuration_FAK = 1,  //ʱɽʣ೷(fill and kill)
	OrderDuration_FOK = 2,  //ʱȫɽ(fill or kill)
	OrderDuration_GFD = 3,  //Ч(good for day)
	OrderDuration_GFS = 4,  //Ч(good for section)
	OrderDuration_GTD = 5,  //ָǰЧ(goodl till date)
	OrderDuration_GTC = 6,  //ǰЧ(good till cancel)
	OrderDuration_GFA = 7,  //ϾǰЧ(good for auction)
};

//ίгɽ
enum OrderQualifier
{
	OrderQualifier_Unknown = 0,
	OrderQualifier_BOC = 1,  //Էż۸(best of counterparty)
	OrderQualifier_BOP = 2,  //ż۸(best of party)
	OrderQualifier_B5TC = 3,  //嵵ʣ೷(best 5 then cancel)
	OrderQualifier_B5TL = 4,  //嵵ʣת޼(best 5 then limit)
};

//ֲַ
enum PositionSide
{
	PositionSide_Unknown = 0,
	PositionSide_Long = 1,   //෽
	PositionSide_Short = 2,   //շ
};

//ƽ־
enum PositionEffect
{
	PositionEffect_Unknown = 0,
	PositionEffect_Open = 1,     //
	PositionEffect_Close = 2,     //ƽ,ȡڶӦĽ
	PositionEffect_CloseToday = 3,     //ƽ
	PositionEffect_CloseYesterday = 4,     //ƽ
};

//ʽֱֲԭ
enum CashPositionChangeReason
{
	CashPositionChangeReason_Unknown = 0,
	CashPositionChangeReason_Trade = 1,  //
	CashPositionChangeReason_Inout = 2,  ///ֲ
	CashPositionChangeReason_Dividend = 3,  //ֺ͹
};

enum AccountState
{
	State_UNKNOWN = 0,       //δ֪
	State_CONNECTING = 1,    //
	State_CONNECTED = 2,     //
	State_LOGGEDIN = 3,      //ѵ¼
	State_DISCONNECTING = 4, //Ͽ
	State_DISCONNECTED = 5,  //ѶϿ
	State_ERROR = 6          //
};

//㷨״̬,ͣ/ָ㷨ʱЧ
enum AlgoOrderStatus 
{
	AlgoOrderStatus_Unknown = 0,
	AlgoOrderStatus_Resume = 1,                  //ָĸ
	AlgoOrderStatus_Pause = 2,                   //ͣĸ
	AlgoOrderStatus_PauseAndCancelSubOrders = 3  //ĸӵ
};

//ͷԴ(ȯȯ)
enum PositionSrc
{
	PositionSrc_Unknown = 0,
	PositionSrc_L1 = 1,          //ͨ
	PositionSrc_L2 = 2           //ר
};

//֤ȯ
enum SecurityType
{
	SecurityType_Unknown = 0,
	SecurityType_Stock = 1,  //Ʊ
	SecurityType_Fund = 2,   //
	SecurityType_Index = 3,  //ָ
	SecurityType_Future = 4,  //ڻ
	SecurityType_Option = 5,  //Ȩ
	SecurityType_Credit = 6,  //
	SecurityType_Bond = 7,    //ծȯ
	SecurityType_Bond_Convertible = 8 //ծȯ
};

//ҵ
enum OrderBusiness
{
	OrderBusiness_NORMAL = 0,                         //ͨ     

	OrderBusiness_STOCK_BUY = 1,                      //Ʊ
	OrderBusiness_STOCK_SELL = 2,                     //Ʊ
	OrderBusiness_MARKET_MAKING = 6,                  //н

	OrderBusiness_FUTURE_BUY_OPEN = 10,               //ڻ뿪
	OrderBusiness_FUTURE_SELL_CLOSE = 11,             //ڻƽ
	OrderBusiness_FUTURE_SELL_CLOSE_TODAY = 12,       //ڻƽ
	OrderBusiness_FUTURE_SELL_CLOSE_YESTERDAY = 13,   //ڻƽ
	OrderBusiness_FUTURE_SELL_OPEN = 14,              //ڻ
	OrderBusiness_FUTURE_BUY_CLOSE = 15,              //ڻƽ
	OrderBusiness_FUTURE_BUY_CLOSE_TODAY = 16,        //ڻƽ
	OrderBusiness_FUTURE_BUY_CLOSE_YESTERDAY = 17,    //ڻƽ
	OrderBusiness_FUTURE_CTP_CONDITIONAL_ORDER = 18,  //ڻCTP

	OrderBusiness_IPO_BUY = 100,                      //¹깺                                                         
	OrderBusiness_CREDIT_BOM = 200,                   //(buying on margin)                                       
	OrderBusiness_CREDIT_SS = 201,                    //ȯ(short selling)                                          
	OrderBusiness_CREDIT_RSBBS = 202,                 //ȯȯ(repay share by buying share)                            
	OrderBusiness_CREDIT_RCBSS = 203,                 //ȯ(repay cash by selling share)                            
	OrderBusiness_CREDIT_DRS = 204,                   //ֱӻȯ(directly repay share)                                   
	OrderBusiness_CREDIT_DRC = 211,                   //ֱӻ(directly repay cash)                                    
	OrderBusiness_CREDIT_CPOM = 205,                  //ƽ(close position on margin)                               
	OrderBusiness_CREDIT_CPOSS = 206,                 //ȯƽ(close position on short selling)                        
	OrderBusiness_CREDIT_BOC = 207,                   //Ʒ(buying on collateral)                                 
	OrderBusiness_CREDIT_SOC = 208,                   //Ʒ(selling on collateral)                                
	OrderBusiness_CREDIT_CI = 209,                    //Ʒת(collateral in)                                        
	OrderBusiness_CREDIT_CO = 210,                    //Ʒת(collateral out)                                       
	OrderBusiness_ETF_BUY = 301,                      //ETF깺(purchase)                                                
	OrderBusiness_ETF_RED = 302,                      //ETF(redemption)                                              
	OrderBusiness_FUND_SUB = 303,                     //Ϲ(subscribing)                                            
	OrderBusiness_FUND_BUY = 304,                     //깺(purchase)                                               
	OrderBusiness_FUND_RED = 305,                     //(redemption)                                             
	OrderBusiness_FUND_CONVERT = 306,                 //ת(convert)                                                
	OrderBusiness_FUND_SPLIT = 307,                   //ֲ(split)                                                  
	OrderBusiness_FUND_MERGE = 308,                   //ϲ(merge)                                                  
	OrderBusiness_BOND_RRP = 400,                     //ծȯع(reverse repurchase agreement (RRP) or reverse repo)   
	OrderBusiness_BOND_CONVERTIBLE_BUY = 401,         //תծ깺(purchase)                                             
	OrderBusiness_BOND_CONVERTIBLE_CALL = 402,        //תծת                                                       
	OrderBusiness_BOND_CONVERTIBLE_PUT = 403,         //תծ                                                       
	OrderBusiness_BOND_CONVERTIBLE_PUT_CANCEL = 404   //תծ۳                                                   
};

//ίдʽ
enum OrderTriggerType
{
	OrderTriggerType_Unknown = 0,
	OrderTriggerType_LastPriceGreaterThanStopPrice = 1,     //¼۴
	OrderTriggerType_LastPriceGreaterEqualStopPrice = 2,    //¼۴ڵ
	OrderTriggerType_LastPriceLessThanStopPrice = 3,       	//¼С
	OrderTriggerType_LastPriceLessEqualStopPrice = 4,       //¼Сڵ
	OrderTriggerType_AskPriceGreaterThanStopPrice = 5,     	//һ۴
	OrderTriggerType_AskPriceGreaterEqualStopPrice = 6,     //һ۴ڵ
	OrderTriggerType_AskPriceLessThanStopPrice = 7,         //һС
	OrderTriggerType_AskPriceLessEqualStopPrice = 8,        //һСڵ
	OrderTriggerType_BidPriceGreaterThanStopPrice = 9,      //һ۴
	OrderTriggerType_BidPriceGreaterEqualStopPrice = 10,    //һ۴ڵ
	OrderTriggerType_BidPriceLessThanStopPrice = 11,        //һС
	OrderTriggerType_BidPriceLessEqualStopPrice = 12        //һСڵ

};

typedef char Symbol[LEN_SYMBOL];
typedef char GmName[LEN_NAME];
typedef char TradingDate[LEN_ISO_DATATIME];

struct Bar
{
	char                    symbol[LEN_SYMBOL];
	double                  bob;                          ///barĿʼʱ
	double                  eob;                          ///barĽʱ
	float                   open;                         ///<̼
	float                   close;                        ///<̼
	float                   high;                         ///<߼
	float                   low;                          ///<ͼ
	double                  volume;                       ///<ɽ
	double                  amount;                       ///<ɽ
	float                   pre_close;                    ///ֻ̼ۣƵݸֵ

	long long               position;                     ///<ֲ
	char                    frequency[LEN_FREQUENCY];     ///barƵ
};

struct OrderQueue
{
	int        total_orders;                                ///ίб
	int        queue_orders;                                ///ίԪظ(50)
	int        queue_volumes[LEN_MAX_ORDER_QUEUE];          ///ί(50пС50, Чݳȡqueue_orders)
};

struct Quote
{
	float      bid_price;                            ///ί
	long long  bid_volume;                           ///ί
	float      ask_price;                            ///ί
	long long  ask_volume;                           ///ί

	OrderQueue *bid_q;                               ///ίж(Level-2¶)
	OrderQueue *ask_q;                               ///ίж(Level-2¶)
};

struct Tick
{
	char                   symbol[LEN_SYMBOL];
	double                 created_at;               ///<utcʱ䣬ȷ
	float                  price;                    ///<¼
	float                  open;                     ///<̼
	float                  high;                     ///<߼
	float                  low;                      ///<ͼ
	double                 cum_volume;               ///<ɽ
	double                 cum_amount;               ///<ɽܽ/³ɽ,ۼֵ
	long long              cum_position;             ///<Լֲ(),ۼֵ
	double                 last_amount;              ///<˲ʱɽ
	int                    last_volume;              ///<˲ʱɽ
	double                 iopv;                     ///ʵʱοֵ
	int                    trade_type;               ///(),Ӧ࿪,ƽ
	Quote                  quotes[DEPTH_OF_QUOTE];   ///, ±0ʼ0-ʾһ1-ʾڶ

};

struct LatestPrice
{
	char                   symbol[LEN_SYMBOL];
	double                 created_at;                ///<utcʱ䣬ȷ
	float                  price;                     ///<¼
};

struct L2Transaction
{
	char                   symbol[LEN_SYMBOL];
	double                 created_at;               ///ɽʱ䣬utcʱ
	float                  price;                    ///ɽ
	long long              volume;					 ///ɽ
	char                   side;                     ///̱
	char                   exec_type;                ///ɽ
	long long              exec_index;               ///ɽ
	long long              ask_order_index;          ///ίб
	long long              bid_order_index;          ///ίб
};

struct L2Order
{
	char                   symbol[LEN_SYMBOL];
	double                 created_at;               ///ίʱ䣬utcʱ
	float                  price;                    ///ίм
	long long              volume;					 ///ί
	char                   side;                     ///
	char                   order_type;               ///ί
	long long              order_index;              ///ίб
};

struct L2OrderQueue
{
	char                   symbol[LEN_SYMBOL];
	double                 created_at;                                  ///ʱ䣬utcʱ
	float                  price;                                       ///ίм
	long long              volume;					                    ///ί
	char                   side;                                        ///
	int                    queue_orders;                                ///ίԪظ(50)
	int                    queue_volumes[LEN_MAX_ORDER_QUEUE];          ///ί(50пС50, Чݳȡqueue_orders)
};

struct VarietyInfo
{
	char     variety_name[LEN_NAME];          //Ʒƣȫдǰ׺
	int      sec_type;                        //Ʒ
	int      sec_type_ext;                    //Ʒչ
	char     exchange[LEN_EXCHANGE];          //
	char     quote_unit[LEN_TYPE];            //۵λ
	double   price_tick;                      //С䶯λ  
	double   multiplier;                      //"Լ (ƱȨĺԼλƷȨĽ׵λָȨĺԼ"
	int      trade_n;                         //ƶȣ0ʾT+01ʾT+12ʾT+2
	char     option_type;                     //ȨʽE:ŷʽA:ʽ 
};

struct OrderRequest
{
	char         symbol[LEN_SYMBOL];                      //symbol                                      
	int          side;                                    //ȡֵοenum OrderSide            
	int          position_effect;                         //ƽ־ȡֵοenum PositionEffect       
	int          order_type;                              //ίͣȡֵοenum OrderType            
	double       price;                                   //ίм۸                                    
	long long    volume;                                  //ί    
	double       stop_price;                              //ֹ/ֹӯ
	int          trigger_type;                            //Ĵ
	int          order_business;                          //ûһд0
};

struct AlgoOrderRequest
{
	char         symbol[LEN_SYMBOL];                      //symbol                                      
	int          side;                                    //ȡֵοenum OrderSide            
	int          position_effect;                         //ƽ־ȡֵοenum PositionEffect       
	int          order_type;                              //ίͣȡֵοenum OrderType            
	double       price;                                   //ίм۸                                    
	long long    volume;                                  //ί    
};


struct Order
{
	char         strategy_id[LEN_ID];                     //ID                                      
	char         account_id[LEN_ID];                      //˺ID                                      
	char         account_name[LEN_NAME];                  //˻¼                                  

	char         cl_ord_id[LEN_ID];                       //ίпͻID                                
	char         order_id[LEN_ID];                        //ίй̨ID                     
	char         ex_ord_id[LEN_ID];                       //ίнID   
	char         algo_order_id[LEN_ID];                   //㷨ĸID
	int          order_business;                          //ҵ

	char         symbol[LEN_SYMBOL];                      //symbol                                      
	int          side;                                    //ȡֵοenum OrderSide            
	int          position_effect;                         //ƽ־ȡֵοenum PositionEffect       
	int          position_side;                           //ֲַȡֵοenum PositionSide         

	int          order_type;                              //ίͣȡֵοenum OrderType            
	int          order_duration;                          //ίʱԣȡֵοenum OrderDuration    
	int          order_qualifier;                         //ίгɽԣȡֵοenum OrderQualifier   
	int          order_src;                               //ίԴȡֵοenum OrderSrc   
	int          position_src;                            //ͷԴȯȡֵο enum PositionSrc
	char         debtsno[LEN_ID];                         //ҵ, /ʱӦĺԼ
	int          repay_type;                              //ҵ, ʱǷֻϢ 0-1-

	int          status;                                  //ί״̬ȡֵοenum OrderStatus          
	int          ord_rej_reason;                          //ίоܾԭȡֵοenum OrderRejectReason
	char         ord_rej_reason_detail[LEN_INFO];         //ίоܾԭ                            

	double       price;                                   //ίм۸                                    
	double       stop_price;                              //ίֹ/ֹӯ۸    
	int          trigger_type;                            //ίдʽCTP

	int          order_style;                             //ίзȡֵο enum OrderStyle          
	long long    volume;                                  //ί                                      
	double       value;                                   //ίж                                      
	double       percent;                                 //ίаٷֱ                                  
	long long    target_volume;                           //ίĿ                                  
	double       target_value;                            //ίĿ                                  
	double       target_percent;                          //ίĿٷֱ                              

	long long    filled_volume;                           //ѳ                                      
	double       filled_vwap;                             //ѳɾ                                    
	double       filled_amount;                           //ѳɽ                                    
	double       filled_commission;                       //ѳ                                  

	long long    created_at;                              //ίдʱ                                
	long long    updated_at;                              //ίиʱ  

	char         origin_product[LEN_NAME];                //ίԴ
	char         origin_module[LEN_NAME];                 //ίзʽ
};

struct AlgoOrder
{
	char         strategy_id[LEN_ID];                     //ID                                      
	char         account_id[LEN_ID];                      //˺ID                                      
	char         account_name[LEN_NAME];                  //˻¼                                  

	char         cl_ord_id[LEN_ID];                       //ίпͻID                                
	char         order_id[LEN_ID];                        //ίй̨ID                                  
	char         ex_ord_id[LEN_ID];                       //ίнID
	int          order_business;                          //ҵ

	char         symbol[LEN_SYMBOL];                      //symbol                                      
	int          side;                                    //ȡֵοenum OrderSide            
	int          position_effect;                         //ƽ־ȡֵοenum PositionEffect       
	int          position_side;                           //ֲַȡֵοenum PositionSide         

	int          order_type;                              //ίͣȡֵοenum OrderType            
	int          order_duration;                          //ίʱԣȡֵοenum OrderDuration    
	int          order_qualifier;                         //ίгɽԣȡֵοenum OrderQualifier   
	int          order_src;                               //ίԴȡֵοenum OrderSrc    
	int          position_src;                            //ͷԴȯȡֵο enum PositionSrc

	int          status;                                  //ί״̬ȡֵοenum OrderStatus          
	int          ord_rej_reason;                          //ίоܾԭȡֵοenum OrderRejectReason
	char         ord_rej_reason_detail[LEN_INFO];         //ίоܾԭ                            

	double       price;                                   //ίм۸                                    
	double       stop_price;                              //ίֹ/ֹӯ۸                       

	int          order_style;                             //ίзȡֵο enum OrderStyle          
	long long    volume;                                  //ί                                      
	double       value;                                   //ίж                                      
	double       percent;                                 //ίаٷֱ                                  
	long long    target_volume;                           //ίĿ                                  
	double       target_value;                            //ίĿ                                  
	double       target_percent;                          //ίĿٷֱ                              

	long long    filled_volume;                           //ѳ                                      
	double       filled_vwap;                             //ѳɾ                                    
	double       filled_amount;                           //ѳɽ                                    
	double       filled_commission;                       //ѳ     

	char         algo_provider[LEN_NAME];                 //㷨AppID
	char         algo_name[LEN_NAME];                     //㷨
	char         algo_param[LEN_PARAM];                   //㷨Բ
	int          algo_status;                             //㷨״̬,ΪAlgoOrder PauseΣȡֵο enum AlgoOrderStatus
	char         algo_comment[LEN_COMMENT];               //㷨ע

	long long    created_at;                              //ίдʱ                                
	long long    updated_at;                              //ίиʱ  

	char         origin_product[LEN_NAME];                //ίԴ
	char         origin_module[LEN_NAME];                 //ίзʽ
};

struct ExecRpt
{
	char               strategy_id[LEN_ID];                  //ID                                                                                                        
	char               account_id[LEN_ID];                   //˺ID                                                       
	char               account_name[LEN_NAME];               //˻¼                                                                                                    

	char               cl_ord_id[LEN_ID];                    //ίпͻID                                                                                                  
	char               order_id[LEN_ID];                     //ίй̨ID                                                                                                    
	char               exec_id[LEN_ID];                      //ίлرID                                                                                                    

	char               symbol[LEN_SYMBOL];                   //symbol                                                                                                        

	int                position_effect;                      //ƽ־ȡֵοenum PositionEffect                                                                         
	int                side;                                 //ȡֵοenum OrderSide                                                                              
	int                ord_rej_reason;                       //ίоܾԭȡֵοenum OrderRejectReason                                                                  
	char               ord_rej_reason_detail[LEN_INFO];      //ίоܾԭ                                                                                              
	int                exec_type;                            //ִлر, ȡֵοenum ExecType                                                                           

	double             price;                                //ίгɽ۸                                                                                                  
	long long          volume;                               //ίгɽ                                                                                                    
	double             amount;                               //ίгɽ                                                                                                  
	double             commission;                           //ίгɽ                                                                                                
	double             cost;                                 //ίгɽɱ  
	long long          created_at;                           //رʱ
	int                order_business;                       //ҵ
};

struct Cash
{
	char          account_id[LEN_ID];                        //˺ID               
	char          account_name[LEN_NAME];                    //˻¼                                                                   

	int           currency;                                  //                                                                         

	double        nav;                                        //ֵ(cum_inout + cum_pnl + fpnl - cum_commission)                            
	double        pnl;                                        //(nav-cum_inout)                                                        
	double        fpnl;                                       //ӯ(sum(each position fpnl))                                            
	double        fpnl_diluted;                               //ֲָӯ,ֲ̯־((price-vwap_diluted)*volume*multiplier)
	double        frozen;                                     //ֲռʽ                                                                 
	double        order_frozen;                               //ҵʽ                                                                 
	double        available;                                  //ʽ                                                                     
															  //no  leverage:  available=(cum_inout + cum_pnl - cum_commission - frozen - order_frozen)        
															  //has leverage:  fpnl     =(fpnl>0 ? fpnl : (frozen < |fpnl|) ? (frozen-|fpnl|) : 0)             
															  //               available=(cum_inout + cum_pnl - cum_commission - frozen - order_frozen + fpnl) 
	double        balance;                                    //ʽ                                                                     
	double        market_value;                               //ֲֵ
	double        market_value_long;                          //Ȩֵ(Ȩ)
	double        market_value_short;                         //ֵ(Ȩ)
	double        used_bail;                                  //ñ֤(Ȩ)
	double        enable_bail;                                //ñ֤(Ȩ)
	double        cum_inout;                                  //ۼƳ                                                                   
	double        cum_trade;                                  //ۼƽ׶                                                                   
	double        cum_pnl;                                    //ۼƽ(û۳)                                                   
	double        cum_commission;                             //ۼ                                                                   

	double        last_trade;                                 //һν׶                                                                 
	double        last_pnl;                                   //һ                                                                   
	double        last_commission;                            //һ                                                                 
	double        last_inout;                                 //һγ                                                                 
	int           change_reason;                              //ʽԭȡֵοenum CashPositionChangeReason                          
	char          change_event_id[LEN_ID];                    //ʽ¼ID     

	long long     created_at;                                 //ʽʼʱ
	long long     updated_at;                                 //ʽʱ

};

struct Position
{
	char                 account_id[LEN_ID];              //˺ID                                       
	char                 account_name[LEN_NAME];          //˻¼                                                                                       

	char                 symbol[LEN_SYMBOL];              //symbol                                       
	int                  side;                            //ֲַȡֵοenum PositionSide          
	long long            volume;                          //ֲܳ; ֲ(volume-volume_today)                                                          
	long long            volume_today;                    //ճֲ                                                                                       
	double               vwap;                            //ֲ־(ƱΪڿּ۵ĳֲ־ۣڻΪڽ۵ĳֲ־)  
	double               vwap_diluted;                    //̯ɱ
	double               vwap_open;                       //ڿּ۵ĳֲ־(ڻ)
	double               amount;                          //ֲֶ(volume*vwap*multiplier)                                                                   

	double               price;                           //ǰ۸                                                                                     
	double               fpnl;                            //ֲָӯ((price-vwap)*volume*multiplier) 
	double               fpnl_diluted;                    //ֲָӯ,ڳֲ־((price-vwap_diluted)*volume*multiplier)
	double               fpnl_open;                       //ֲָӯ,ڿ־ۣڻ((price-vwap_open)*volume*multiplier)
	double               cost;                            //ֲֳɱ(vwap*volume*multiplier*margin_ratio)                                                    
	long long            order_frozen;                    //ҵλ                                                                                     
	long long            order_frozen_today;              //ҵֲλ                                                                                 
	long long            available;                       //ܲλ(volume-order_frozen); λ(available-available_today)                           
	long long            available_today;                 //ýλ(volume_today-order_frozen_today)
	long long            available_now;                   //ǰƽλ
	long long            credit_position_sellable_volume; //Ʒλ()
	double               market_value;                    //ֲֵ

	double               last_price;                      //һγɽ                                                                                     
	long long            last_volume;                     //һγɽ                                                                                     
	long long            last_inout;                      //һγֲ                                                                                 
	int                  change_reason;                   //λԭȡֵοenum CashPositionChangeReason                                              
	char                 change_event_id[LEN_ID];         //ʽ¼ID                                                                             

	int                  has_dividend;                    //ֲзֺ   
	long long            created_at;                      //ʱ
	long long            updated_at;                      //λʱ

};

struct Account 
{
	char            account_id[LEN_ID];           //˺ID
	char            account_name[LEN_NAME];       //˻¼
	char            title[LEN_NAME];              //˺
	char            intro[LEN_INFO];              //˺
	char            comment[LEN_INFO];            //˺űע
};

struct AccountStatus
{
	char            account_id[LEN_ID];           //˺ID
	char            account_name[LEN_NAME];       //˻¼
	int             state;                        //˻״̬
	int             error_code;                   //
	char            error_msg[LEN_INFO];          //Ϣ
};

struct Parameter
{
	char   key[LEN_ID];          //
	double value;                //ֵ
	double min;                  //õСֵ
	double max;                  //õֵ
	char   name[LEN_NAME];       //
	char   intro[LEN_INFO];      //˵
	char   group[LEN_NAME];      //
	bool   readonly;             //Ƿֻ
};

struct Indicator
{
	char      account_id[LEN_ID];             //˺ID
	double    pnl_ratio;                      //ۼ(pnl/cum_inout)
	double    pnl_ratio_annual;               //껯
	double    sharp_ratio;                    //ձ
	double    max_drawdown;                   //س
	double    risk_ratio;                     //ձ
	int       open_count;                     //ִ
	int       close_count;                    //ƽִ
	int       win_count;                      //ӯ
	int       lose_count;                     //
	double    win_ratio;                      //ʤ

	long long  created_at;                    //ָ괴ʱ
	long long  updated_at;                    //ָʱ
};

struct CollateralInstrument
{
	char                 symbol[LEN_SYMBOL];  //֤ȯ
	char                 name[LEN_NAME];      //
	double               pledge_rate;         //
};

struct BorrowableInstrument
{
	char                 symbol[LEN_SYMBOL];        //֤ȯ
	char                 name[LEN_NAME];            //
	double               margin_rate_for_cash;      //ʱ֤
	double               margin_rate_for_security;  //ȯ֤
};

struct BorrowableInstrumentPosition
{
	char                 symbol[LEN_SYMBOL];        //֤ȯ
	char                 name[LEN_NAME];            //
	double               balance;                   //֤ȯ
	double               available;                 //֤ȯ
};

struct CreditContract
{
	char symbol[LEN_SYMBOL];              //֤ȯ stkcode    
	char name[LEN_NAME];                  //
	int orderdate;                        //ί                   
	char ordersno[LEN_ID];                //ί                     
	char creditdirect;                    //ȯ               
	double orderqty;                      //ί                   
	double matchqty;                      //ɽ                   
	double orderamt;                      //ίн                   
	double orderfrzamt;                   //ίж               
	double matchamt;                      //ɽ                   
	double clearamt;                      //                   
	char lifestatus;                      //Լ״̬                   
	int enddate;                          //ծֹ               
	int oldenddate;                       //ԭʼĸծֹ         
	double creditrepay;                   //T֮ǰ黹            
	double creditrepayunfrz;              //Tչ黹                
	double fundremain;                    //Ӧ                   
	double stkrepay;                      //T֮ǰ黹            
	double stkrepayunfrz;                 //Tչ黹                
	double stkremain;                     //Ӧ֤ȯ               
	double stkremainvalue;                //Ӧ֤ȯֵ               
	double fee;                           //ȯϢ             
	double overduefee;                    //δϢ           
	double fee_repay;                     //Ϣ               
	double punifee;                       //ϢķϢ             
	double punifee_repay;                 //Ϣ                 
	double rights;                        //δȨ             
	double overduerights;                 //δȨ             
	double rights_repay;                  //Ȩ                 
	double lastprice;                     //¼                     
	double profitcost;                    //ӯ                   
	int sysdate;                          //ϵͳ                   
	char sno[LEN_ID];                     //Լ                   
	int lastdate;                         //һμϢ       
	int closedate;                        //Լȫ           
	double punidebts;                     //ڱϢ               
	double punidebts_repay;               //Ϣ               
	double punidebtsunfrz;                //ڱϢ               
	double punifeeunfrz;                  //ϢѷϢ               
	double punirights;                    //Ȩ淣Ϣ               
	double punirights_repay;              //Ȩ淣Ϣ               
	double punirightsunfrz;               //Ȩ淣Ϣ               
	double feeunfrz;                      //ʵʱϢ               
	double overduefeeunfrz;               //ʵʱϢ           
	double rightsqty;                     //δȨ             
	double overduerightsqty;              //δȨ    
};


struct CreditCash
{
	double fundintrrate;                        //                 
	double stkintrrate;                         //ȯ                 
	double punishintrrate;                      //Ϣ                 
	char   creditstatus;                        //״̬                 
	double marginrates;                         //άֵ             
	double realrate;                            //ʵʱ             
	double asset;                               //ʲ                   
	double liability;                           //ܸծ                   
	double marginavl;                           //֤             
	double fundbal;                             //ʽ                 
	double fundavl;                             //ʽ               
	double dsaleamtbal;                         //ȯʽ         
	double guaranteeout;                        //תʲ           
	double gagemktavl;                          //֤ȯֵ             
	double fdealavl;                            //ʱ                 
	double ffee;                                //Ϣ                 
	double ftotaldebts;                         //ʸծϼ             
	double dealfmktavl;                         //Ӧȯֵ             
	double dfee;                                //ȯϢ                 
	double dtotaldebts;                         //ȯծϼ             
	double fcreditbal;                          //Ŷ             
	double fcreditavl;                          //ʿö             
	double fcreditfrz;                          //ʶȶ             
	double dcreditbal;                          //ȯŶ             
	double dcreditavl;                          //ȯö             
	double dcreditfrz;                          //ȯȶ             
	double rights;                              //Ȩ                 
	double serviceuncomerqrights;               //Ȩ(;)           
	double rightsqty;                           //Ȩ                 
	double serviceuncomerqrightsqty;            //Ȩ(;)           
	double acreditbal;                          //ܶ                   
	double acreditavl;                          //ܿö               
	double acashcapital;                        //ֽʲʲȯ     
	double astkmktvalue;                        //֤ȯֵ롢ǵƷ     
	double withdrawable;                        //ȡʽ                                   
	double netcapital;                          //ʲ                                     
	double fcreditpnl;                          //ӯ                                   
	double dcreditpnl;                          //ȯӯ                                   
	double fcreditmarginoccupied;               //ռñ֤                             
	double dcreditmarginoccupied;               //ȯռñ֤                             
	double collateralbuyableamt;                //򵣱Ʒʽ                             
	double repayableamt;                        //ɻ                                 
	double dcreditcashavl;                      //ȯʽ     
};

//¹깺
struct IPOQI
{
	char exchange[LEN_TYPE];        //г
	double quota;                   //г
	double sse_star_quota;          //Ϻƴ
};

struct IPOInstruments
{
	char     symbol[LEN_SYMBOL];     //깺¹symbol
	double   price;                  //깺۸
	int      min_vol;                //깺С
	int      max_vol;                //깺
};

struct IPOMatchNumber
{
	char order_id[LEN_ID];           //ίк
	char symbol[LEN_SYMBOL];         //¹symbol
	int   volume;                    //ɽ
	char match_number[LEN_ID];       //깺
	int  order_at;                   //ί
	int  match_at;                    //
};

struct IPOLotInfo
{
	char symbol[LEN_SYMBOL];   //¹symbol   
	int order_at;              //ί     
	int lot_at;                //ǩ     
	int lot_volume;            //ǩ     
	int give_up_volume;        //     
	double price;              //ǩ۸     
	double amount;             //ǩ     
	double pay_volume;         //ѽɿ   
	double pay_amount;         //ѽɿ   

};

struct SmartReorderParameter
{
	char      symbol[LEN_SYMBOL];
	double    price;
	int       volume;
	int       side;
	int       order_type;
	int       position_effect;
	int       repeat_n;
	int       max_price_offset;
	int       time_out;
	int       time_wait;
	char      account_id[LEN_ID];             //˺ID
	int       reorder_id;                     //:رܵID, ڳܵ
};

struct OptionPreorderValidVolumeRequest
{
	char      symbol[LEN_SYMBOL];
	double    price;
	int       side;
	int       covered_flag;
	char      account_id[LEN_ID];             //˺ID
};

struct OptionPreorderSellMarginRequest
{
	char      symbol[LEN_SYMBOL];
	char      account_id[LEN_ID];             //˺ID
};

struct TradingTimes
{
	char       variety_name[LEN_ID];                     //ƷID
	char       time_trading[LEN_TIME_LIST];              //ʱ
	char       time_callauction[LEN_TIME_LIST];          //Ͼʱ
};

struct BacktestConfig 
{
	BacktestConfig()
	{
		initial_cash = 1000000;
		transaction_ratio = 1;
		commission_ratio = 0;
		commission_unit = 0;
		slippage_ratio = 0;
		option_float_margin_ratio1 = 0.2;
		option_float_margin_ratio2 = 0.4;
		adjust = 0;
		match_mode = 0;
		check_cache = 1;
		intraday = 0;
	}

	char   start_time[LEN_ISO_DATATIME];
	char   end_time[LEN_ISO_DATATIME];
	double initial_cash;
	double transaction_ratio;
	double commission_ratio;
	double commission_unit;
	double slippage_ratio;
	double option_float_margin_ratio1;
	double option_float_margin_ratio2;
	int    adjust;
	int    match_mode;
	int    intraday;
	int    check_cache;
};


// ݽṹ ////////////////////////////////////////////

struct SymbolInfo
{
	// Ĵ
	char symbol[LEN_SYMBOL];
	// ֤ȯƷִ
	long long sec_type1;
	// ֤ȯƷϸ
	long long sec_type2;
	// 
	long long board;
	// 
	char exchange[LEN_EXCHANGE];
	// Ĵ
	char sec_id[LEN_SYMBOL];
	// 
	char sec_name[LEN_NAME];
	// ļ
	char sec_abbr[LEN_NAME];
	// С䶯λ
	double price_tick;
	// ƶ 0ʾT+0 1ʾT+1 2ʾT+2
	long long trade_n;
	//  ֤ȯ/ָ ƷԼĹ
	char listed_date[LEN_ISO_DATATIME];
	//  Ʊ/ ڻ/Ȩĵ() תծصǼ
	char delisted_date[LEN_ISO_DATATIME];
	// ʲ
	char underlying_symbol[LEN_SYMBOL];
	// Ȩʽ
	char option_type[LEN_TYPE];
	// Ȩ֤1
	double option_margin_ratio1;
	// Ȩ֤2
	double option_margin_ratio2;
	// Լ
	char call_or_put[LEN_TYPE];
	// תծʼת
	char conversion_start_date[LEN_ISO_DATATIME];
	// ʱ
	char update_time[LEN_ISO_DATATIME];
	// ֤ȯ-
	int sec_type;
	// ڿʼ, ûʱʱΪַ, yyyy-mm-dd
	char delisting_begin_date[LEN_ISO_DATATIME];
};

struct SymbolContent
{
	// 
	char trade_date[LEN_ISO_DATATIME];
	// Լ
	bool is_adjusted;
	// Ƿͣ
	bool is_suspended;
	// ֲ
	long long position;
	// 
	double settle_price;
	// 
	double pre_settle;
	// ̼
	double pre_close;
	// ͣ
	double upper_limit;
	// ͣ
	double lower_limit;
	// 
	double turn_rate;
	// Ȩ
	double adj_factor;
	// ֤
	double margin_ratio;
	// תɼ
	double conversion_price;
	// Ȩ
	double exercise_price;
	// Լ
	long long multiplier;
	//  info еֶ
	SymbolInfo info;
	// ǷST
	bool is_st;
};

struct TradingDateContent
{
	//// Ȼ
	char date[LEN_ISO_DATATIME];
	//// 
	char trade_date[LEN_ISO_DATATIME];
	//// һ
	char next_trade_date[LEN_ISO_DATATIME];
	//// һ
	char pre_trade_date[LEN_ISO_DATATIME];
};

struct Session
{
	char start[LEN_ISO_DATATIME];
	char end[LEN_ISO_DATATIME];
};

struct TradingSession
{
	// Ĵ
	char symbol[LEN_SYMBOL];
	// 
	char exchange[LEN_EXCHANGE];

	// ʱ
	Session time_trading[MAX_TRADING_SESSION_NUM];
	// time_tradingʵʳ
	int time_trading_num;

	// Ͼʱ
	Session time_auction[MAX_TRADING_SESSION_NUM];
	// time_auctionʵʳ
	int time_auction_num;
};

struct ContractExpireRestDays
{
	//  ַ
	char date[LEN_ISO_DATATIME];
	// Ĵ
	char symbol[LEN_SYMBOL];
	// ʣ Ϊַ
	char days_to_expire[LEN_INFO];
};

struct StkIndustryCategory
{
	// ҵ
	char industry_code[LEN_ID];
	// ҵ
	char industry_name[LEN_NAME];
};

struct StkIndustryConstituent
{
	// ҵ
	char industry_code[LEN_ID];
	// ҵ
	char industry_name[LEN_NAME];
	// ɷֹƱ, ʽ: exchange.sec_id
	char symbol[LEN_SYMBOL];
	// ɷֹƱ
	char sec_name[LEN_NAME];
	// , ʱ, ʽΪ: YYYY-MM-DD
	char date_in[LEN_ISO_DATATIME];
	// ޳, ʱ, ʽΪ: YYYY-MM-DD
	char date_out[LEN_ISO_DATATIME];
};

struct StkSymbolIndustry
{
	// Ʊ, ʽ: exchange.sec_id
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// ҵ
	char industry_code[LEN_ID];
	// ҵ
	char industry_name[LEN_NAME];
};

struct StkIndexConstituent
{
	// ָ
	char index[LEN_SYMBOL];
	// ɷֹɴ
	char symbol[LEN_SYMBOL];
	// ɷֹȨ
	double weight;
	// ֵ, λ: Ԫ
	double market_value_total;
	// ֵͨ, λ: Ԫ
	double market_value_circ;
	// , ʱ, ʽΪ: YYYY-MM-DD
	char trade_date[LEN_ISO_DATATIME];
};

struct StkDividend
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// ䷽, ֺֽ, ͹, ת
	char scheme_type[LEN_LONG_TYPE];
	// , ʱ, ʽΪ: YYYY-MM-DD
	char pub_date[LEN_ISO_DATATIME];
	// ȨϢ, ʱ, ʽΪ: YYYY-MM-DD
	char ex_date[LEN_ISO_DATATIME];
	// ȨǼ, ʱ, ʽΪ: YYYY-MM-DD
	char equity_reg_date[LEN_ISO_DATATIME];
	// ֽ(Ϣ), ʱ, ʽΪ: YYYY-MM-DD
	char cash_pay_date[LEN_ISO_DATATIME];
	// ͣתɷݵ, ʱ, ʽΪ: YYYY-MM-DD
	char share_acct_date[LEN_ISO_DATATIME];
	// , ͣתɷн, ʱ, ʽΪ: YYYY-MM-DD
	char share_lst_date[LEN_ISO_DATATIME];
	// ˰Ԫ/10ɣ
	double cash_af_tax;
	// ˰ǰԪ/10ɣ
	double cash_bf_tax;
	// ͹ɱ, 10:X
	double bonus_ratio;
	// ת, 10:X
	double convert_ratio;
	// ɱ׼
	char base_date[LEN_ISO_DATATIME];
	// ɱ(׼ɱ)
	double base_share;
	// ɶ
	char dvd_target[LEN_INFO];
};

struct StkAdjFactor
{
	// 
	char trade_date[LEN_ISO_DATATIME];
	// պȨ, TպȨ=T-1յ̼/Tǰռ
	double adj_factor_bwd;
	// ۼƺȨ, TۼƺȨ=TպȨ*T-1ۼƺȨ
	// һۼƺȨ=һȨӣ
	double adj_factor_bwd_acc;
	// ǰȨ, TǰȨ=TպȨ/Ȩ׼պȨ
	double adj_factor_fwd;
	// ۼǰȨ, TۼǰȨ=TպȨ
	// T-1ۼǰȨ=TպȨ*T-1պȨ
	// һۼǰȨ=ۼƺȨӣ
	double adj_factor_fwd_acc;
};

struct StkSectorCategory
{
	// 
	char sector_code[LEN_SYMBOL];
	// 
	char sector_name[LEN_NAME];
};

struct StkSectorConstituent
{
	// 
	char sector_code[LEN_SYMBOL];
	// 
	char sector_name[LEN_NAME];
	// Ʊ, ʽ: exchange.sec_id
	char symbol[LEN_SYMBOL];
	// ɷֹƱ
	char sec_name[LEN_NAME];
};

struct StkSymbolSector
{
	// Ʊ, ʽ: exchange.sec_id
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// 
	char sector_code[LEN_SYMBOL];
	// 
	char sector_name[LEN_NAME];
};

struct StkRation
{
	// Ĵ
	char symbol[LEN_SYMBOL];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// ȨǼ
	char equity_reg_date[LEN_ISO_DATATIME];
	// ȨϢ
	char ex_date[LEN_ISO_DATATIME];
	// ɱ
	double ration_ratio;
	// ɼ۸
	double ration_price;
};

struct StkShareholderNum
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// ֹ
	char expiry_date[LEN_ISO_DATATIME];
	// ɶ
	long long total_share;
	// Aɹɶ
	long long total_share_a;
	// ͨBɹɶ
	long long total_share_b;
	// ͨHɹɶ
	long long total_share_h;
	// ɶ
	long long other_share;
	// ȹɹɶȨָ
	long long total_share_pfd;
	// ɶȯ
	long long total_share_mgn;
	// ɶȯ
	long long total_share_no_mgn;
};

struct StkShareholder
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// ֹ
	char expiry_date[LEN_ISO_DATATIME];
	// ɶ
	char holder_name[LEN_COMMENT];
	// ɶţΣ
	int holder_rank;
	// ɶ
	char holder_type[LEN_INFO];
	// ɶ
	char holder_attr[LEN_INFO];
	// ɷ(ɷ)
	char share_type[LEN_INFO];
	// ɣ
	double share_num;
	// ֹɱ1, ֹռܹɱ%
	double share_ratio1;
	// ֹɱ2, ֹռͨɱ%
	double share_ratio2;
	// Ѻɷ, ȨѺ漰ɣ
	double share_pledge;
	// ɷ, Ȩ漰ɣ
	double share_freeze;
};

struct StkShareChange
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// ˾
	char company_name[LEN_COMMENT];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// ɱ䶯
	char chg_date[LEN_ISO_DATATIME];
	// ɱ䶯ԭ
	char chg_reason[LEN_COMMENT];
	// ɱ䶯¼
	char chg_event[LEN_COMMENT];
	// ܹɱ, δͨɷ+ͨɷ, λ: 
	double share_total;
	// δͨɷ
	double share_total_nlf;
	// ˹ɷ: з˹ + ᷨ˹ + ˹ɷ, λ: 
	double share_prom;
	// з˹: ҳֹ+з˹, λ: 
	double share_prom_state;
	// ҹ
	double share_state;
	// з˹
	double share_state_lp;
	// ᷨ˹: ᷨ˹+ⷨ˹, λ: 
	double share_prom_soc;
	// ᷨ˹
	double share_dc_lp;
	// ⷨ˹
	double share_os_lp;
	// ˹ɷ
	double share_prom_other;
	// ļ˹ɷ: ļҹ+ļڷ˹+ļⷨ˹, λ: 
	double share_rs;
	// ļҹ
	double share_rs_state;
	// ļڷ˹: ļڹз˹+ļᷨ˹, λ: 
	double share_rs_dc_lp;
	// ļڹз˹
	double share_rs_state_lp;
	// ļᷨ˹
	double share_rs_soc_lp;
	// ļⷨ˹
	double share_rs_os_lp;
	// ڲְ
	double share_emp_nlf;
	// ȹ
	double share_pfd_nlf;
	// δͨɷ
	double share_oth_nlf;
	// ͨɷ
	double share_circ;
	// ɷ
	double share_ttl_unl;
	// ͨɣAɣ
	double share_a_unl;
	// ʹɣBɣ
	double share_b_unl;
	// ʹɣHɣ
	double share_h_unl;
	// ͨɷ
	double share_oth_unl;
	// ɷ
	double share_ttl_ltd;
	// һɷ: ۹ҳֹ+ ۹з˳ֹ+ ʳֹ+ ʳֹ+ ɷ+ ߹ֹܳ, λ: 
	double share_gen_ltd;
	// ۹ҳֹ
	double share_state_ltd;
	// ۹з˳ֹ
	double share_state_lp_ltd;
	// ʳֹ: ۾ڷǹз˳ֹ+۾Ȼ˳ֹ, λ: 
	double share_oth_dc_ltd;
	// ۾ڷǹз˳ֹ
	double share_nst_dc_lp_ltd;
	// ۾Ȼ˳ֹ
	double share_dc_np_ltd;
	// ʳֹ: ۾ⷨ˳ֹ+۾Ȼ˳ֹ, λ: 
	double share_forn_ltd;
	// ۾ⷨ˳ֹ
	double share_os_lp_ltd;
	// ۾Ȼ˳ֹ
	double share_os_np_ltd;
	// ɷ
	double share_lk_ltd;
	// ߹ֹܳ(ԭʼ¶)
	double share_gm_ltd;
	// ۷˳ֹ: սͶ۹ɷ+һ㷨Ͷ+ ֤ȯͶʻ۹ɷ, λ: 
	double share_plc_lp_ltd;
	// սͶ۹ɷ
	double share_plc_si_ltd;
	// һ㷨Ͷ۹ɷ
	double share_plc_lp_gen_ltd;
	// ֤ȯͶʻ۹ɷ
	double share_plc_fnd_ltd;
	// ͨA
	double share_a_ltd;
	// ͨB
	double share_b_ltd;
	// ͨH
	double share_h_ltd;
	// ۹ɷ
	double share_oth_ltd;
	// 䶯ɷ
	char share_list_date[LEN_ISO_DATATIME];

};

struct StkAbnorChangeStocks
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// 춯
	char change_type[LEN_TYPE];
	// 춯˵
	char change_type_name[LEN_COMMENT];
	// 춯ʼ
	char abnor_start_date[LEN_ISO_DATATIME];
	// 춯
	char abnor_end_date[LEN_ISO_DATATIME];
	// ̼
	double close;
	// ۼƳɽ
	int cum_volume;
	// ۼƳɽ
	double cum_amount;
	// ǵ %
	double prc_change_rate;
	// վʱֵ
	double avg_turn_rate;
	// ͳֵ
	double stat_value;
};

struct StkAbnorChangeDetail
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// 춯
	char change_type[LEN_INFO];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// ׷
	int side;
	// Ӫҵ
	char sales_dept[LEN_COMMENT];
	// 
	double buy_amount;
	// 
	double sell_amount;
	// 
	int rank;
	// ͳ
	char stat_days[LEN_INFO];
};

struct StkQuotaShszhkInfos
{
	// 
	char type[LEN_INFO];
	// ½
	char trade_date[LEN_ISO_DATATIME];
	// ÿն(Ԫ)
	double daily_quota;
	// (Ԫ)
	double day_balance;
	// ʹö(Ԫ)
	double day_used;
	// նʹ(%)
	double day_used_rate;
	// ۼʹܶ(Ԫ)
	//double cum_used;
	//// ۼ(Ԫ)
	//double cum_balance;
	//// ۼռܶȱ(%)
	//double cum_balance_rate;
	// ɽ(Ԫ)
	double day_buy_amount;
	// ɽ()
	double day_buy_volume;
	// ɽ(Ԫ)
	double day_sell_amount;
	// ɽ()
	double day_sell_volume;
	// ɽ(Ԫ)
	double day_net_amount;
	// ͨ()
	double settle_exrate_buy;
	// ͨ()
	double settle_exrate_sell;
};

struct StkHkInstHoldingDetailInfo
{
	// ֤ȯ
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// ֤ȯ
	char sec_name[LEN_NAME];
	// 
	char participant_name[LEN_INFO];
	// ֹ()
	int share_holding;
	// ռѷйɷ(%)
	double shares_rate;
};

struct StkHkInstHoldingInfo
{
	// ֤ȯ
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// ֤ȯ
	char sec_name[LEN_NAME];
	// ۼƳֹ()
	int cum_share_holding;
	// ۼռѷйɷ(%)
	double cum_shares_rate;
};

struct StkActiveStockTop10ShszhkInfo
{
	// ֤ȯ
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// 
	int rank;
	// 
	char type[LEN_INFO];
	// 
	char sec_name[LEN_NAME];
	// ̼۸(Ԫ)
	double close;
	// ǵ(%)
	double price_range;
	// (Ԫ)
	double buy_amount;
	// (Ԫ)
	double sell_amount;
	// ɽ(Ԫ)
	double total_amount;
	// Ʊɽ(Ԫ)
	double stock_total_amount;
	// ɽռ(%)
	double transaction_rate;
	// ֵ(Ԫ)
	double market_value_total;
	// ۼϰ
	int cum_number_of_times;
	// 
	char currency[LEN_TYPE];
};

struct StkMoneyFlowRecord
{
	// Ʊ                                            
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// ʽ
	double main_in;
	// ʽ
	double main_out;
	// ʽ
	double main_net_in;
	// ʽ
	double main_net_in_rate;
	// ʽ
	double super_in;
	// ʽ
	double super_out;
	// 󵥾ʽ
	double super_net_in;
	// 󵥾
	double super_net_in_rate;
	// ʽ
	double large_in;
	// ʽ
	double large_out;
	// 󵥾ʽ
	double large_net_in;
	// 󵥾
	double large_net_in_rate;
	// еʽ
	double mid_in;
	// еʽ
	double mid_out;
	// еʽ
	double mid_net_in;
	// е
	double mid_net_in_rate;
	// Сʽ
	double small_in;
	// Сʽ
	double small_out;
	// Сʽ
	double small_net_in;
	// С
	double small_net_in_rate;
};

struct StkFinanceAuditRecord
{
	// Ʊ
	char symbol[LEN_SYMBOL];
	// ¹
	char pub_date[LEN_ISO_DATATIME];
	// ״ι
	char first_pub_date[LEN_ISO_DATATIME];
	// 
	char rpt_date[LEN_ISO_DATATIME];
	// 
	char audit_date[LEN_ISO_DATATIME];
	// ׼
	char acct_standard[LEN_INFO];
	// ʦ
	char acct_agency[LEN_INFO];
	// עʦ
	char cpa[LEN_INFO];
	// 
	char audit_opinion[LEN_INFO];
	// ʹ
	char audit_opinion_code[LEN_INFO];
	// ĺ
	char audit_no[LEN_INFO];
	// 
	char audit_opinion_text[LEN_TEXT];
};

struct StkFinanceForecastRecord
{
	// Ʊ                               
	char symbol[LEN_SYMBOL];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// Ԥʼ
	char begin_date[LEN_ISO_DATATIME];
	// Ԥֹ
	char end_date[LEN_ISO_DATATIME];
	// Ԥⱨ
	char rpt_type[LEN_TYPE];
	// ҵԤ
	char fcst_type[LEN_TYPE];
	// Ԥָ
	char fcst_field[LEN_INFO];
	// ԤԪ()
	double fcst_amount_max;
	// ԤԪ()
	double fcst_amount_min;
	// ͬԪ
	double amount_ly;
	// ()
	double increase_pct_max;
	// ()
	double increase_pct_min;
	// ָԤ
	char fcst_content[LEN_TEXT];
	// Ԥڵλ
	char ann_fcst_amount_unit[LEN_TYPE];
	// ԭʼԤ()
	double ann_fcst_amount_max;
	// ԭʼԤ()
	double ann_fcst_amount_min;
	// ԭʼͬ
	double ann_amount_ly;
	// ()
	double ann_increase_max;
	// ()
	double ann_increase_min;
	// Ƿ仯
	bool is_change;
	// ҵ䶯ԭ˵
	char change_reason[LEN_TEXT];

};

struct FutContinuousContractsInfo
{
	// Ĵ
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
};

struct FutContractInfo
{
	// Ʒ  --Ʒƣ磺300ָ
	char  product_name[LEN_NAME];
	// ״  --Ʒִ룬磺IFAL
	char  product_code[LEN_TYPE];
	// Լ --磺SHSE.000300 AL
	char  underlying_symbol[LEN_SYMBOL];
	// Լ  --磺2005
	int   multiplier;
	// ׵λ  --磺ÿ200Ԫ5/
	char  trade_unit[LEN_INFO];
	// ۵λ   --磺ָ㣬Ԫң/
	char  price_unit[LEN_INFO];
	// ۸С䶯λ  --磺0.2㣬5Ԫ/
	char  price_tick[LEN_INFO];
	// Լ·  --磺¡¼£112
	char  delivery_month[LEN_INFO];
	// ʱ  --磺9:30-11:3013:00-15:009:0011:30 1:303:00ͽ涨ʱ䡱
	char  trade_time[LEN_INFO];
	// ǵͣ  --ÿռ۸󲨶ƣ磺һս۵ġ10%һսۡ3%
	char  price_range[LEN_INFO];
	// ͽױ֤  --ͱ֤磺Լֵ8%Լֵ5%
	char  minimum_margin[LEN_INFO];
	//    -- 磺Լ·ݵĵ壬ҷ˳ӡԼ·ݵ15գҷڼ˳ӣ·ݵսе֪ͨ
	char  last_trade_date[LEN_COMMENT];
	//   --磺ͬապա
	char  delivery_date[LEN_INFO];
	// ʽ  --磺ֽ𽻸ʵｻ
	char  delivery_method[LEN_INFO];
	//  --нƣ磺йڻϺڻ
	char  exchange_name[LEN_INFO];
	//   --н룬磺CFFEXSHFE
	char  exchange[LEN_SYMBOL];

};

struct FutTransactionRanking
{
	// ڻԼ  --ʹʱοsymbol
	char symbol[LEN_SYMBOL];
	//   --
	char trade_date[LEN_ISO_DATATIME];
	// ڻ˾Ա
	char member_name[LEN_NAME];
	// ֵָ  --λ֡ӺѡָindicatorֱΪɽindicatorΪ'volume'ʱindicatorΪ'long'ʱindicatorΪshortʱ
	int  indicator_number;
	// ָϽ  --λ
	int  indicator_change;
	// 
	int  ranking;
	// αϽ
	int  ranking_change;
	// ж ranking_change ֵǷΪ
	bool ranking_change_is_null;
};

struct FutTransactionRankings
{
	// ڻԼ  --ʹʱοsymbol
	char symbol[LEN_SYMBOL];
	//   --
	char trade_date[LEN_ISO_DATATIME];
	// ڻ˾Ա
	char member_name[LEN_NAME];
	// ֵָ  --λ֡ӺѡָindicatorֱΪɽindicatorΪ'volume'ʱindicatorΪ'long'ʱindicatorΪshortʱ
	int  indicator_number;
	// ָϽ  --λ
	int  indicator_change;
	// 
	int  ranking;
	// αϽ
	int  ranking_change;
	// ж ranking_change ֵǷΪ
	bool ranking_change_is_null;
	// ָ
	char indicator[LEN_NAME];
};

struct FutWarehouseReceiptInfo
{
	//  --
	char trade_date[LEN_ISO_DATATIME];
	// ڻ --ڻƷֶӦ룬磺CFFEXSHFE
	char  exchange[LEN_SYMBOL];
	// ڻ --нƣ磺йڻϺڻ
	char exchange_name[LEN_NAME];
	// ״ --Ʒִ룬磺IFAL
	char product_code[LEN_SYMBOL];
	// Ʒ --Ʒƣ磺300ָ
	char product_name[LEN_NAME];
	// עֵ --
	int  on_warrant;
	// ֵλ -- ֧֣Ʒ
	char warrant_unit[LEN_TYPE];
	// ֿ --
	char warehouse[LEN_NAME];
	// ڻ --
	int  future_inventory;
	// ڻ --
	int  future_inventory_change;
	// ÿ --
	int  warehouse_capacity;
	// ÿ --
	int  warehouse_capacity_change;
	// С --
	int  inventory_subtotal;
	// С --
	int  inventory_subtotal_change;
	// ЧԤ --֧֣Ʒ
	int  effective_forecast;
	// ˮ --
	int  premium;
};

struct FndAdjFactorInfo
{
	//     --½յ
	char trade_date[LEN_ISO_DATATIME];
	// պȨ --TպȨ=T-1յ̼/Tǰռ
	double adj_factor_bwd_acc;
	// ǰȨ   --TǰȨ=TպȨ/Ȩ׼պȨ
	double adj_factor_fwd;
};

struct FndDividendInfo
{
	//    --ѯֺϢĻ
	char fund[LEN_SYMBOL];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// 
	char event_progress[LEN_COMMENT];
	// Ϣ --10:Xÿ10˰ǰֺ
	double dvd_ratio;
	// ׼
	char dvd_base_date[LEN_ISO_DATATIME];
	// ȨǼ
	char rt_reg_date[LEN_ISO_DATATIME];
	// ʵʳϢ
	char ex_act_date[LEN_ISO_DATATIME];
	// ڳϢ
	char ex_dvd_date[LEN_ISO_DATATIME];
	// ں
	char pay_dvd_date[LEN_ISO_DATATIME];
	// ں˻
	char trans_dvd_date[LEN_ISO_DATATIME];
	// Ͷȷ
	char reinvest_cfm_date[LEN_ISO_DATATIME];
	// Ͷʷݶ
	char ri_shr_arr_date[LEN_ISO_DATATIME];
	// Ͷʼ
	char ri_shr_rdm_date[LEN_ISO_DATATIME];
	// ɷ --λԪ
	double earn_distr;
	// ʵʺ --λԪ
	double cash_pay;
	// ׼ջݶֵ
	double base_unit_nv;
	// ɶ
	char dvd_target[LEN_INFO];
};

struct FndSplitInfo
{
	// 
	char  fund[LEN_SYMBOL];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// 
	char split_type[LEN_INFO];
	// 
	double split_ratio;
	// ׼
	char base_date[LEN_ISO_DATATIME];
	// 㳡ڳȨ
	char ex_date[LEN_ISO_DATATIME];
	// ݶǼ
	char share_change_reg_date[LEN_ISO_DATATIME];
	// ¶ֵ
	char nv_split_pub_date[LEN_ISO_DATATIME];
	// ȨǼ
	char rt_reg_date[LEN_ISO_DATATIME];
	// ڳȨ(̼)
	char ex_date_close[LEN_ISO_DATATIME];
};

struct FndEtfConstituents
{
	// ETF
	char etf[LEN_SYMBOL];
	// ETF
	char etf_name[LEN_NAME];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// ɷֹɴ
	char symbol[LEN_SYMBOL];
	// Ʊ
	double amount;
	// ֽ־
	char cash_subs_type[LEN_TYPE];
	// ̶
	double cash_subs_sum;
	// ֽ۱ --λ%
	double cash_premium_rate;
};

struct FndPortfolioStockInfo
{
	//   --ѯʲϵĻ
	char fund[LEN_SYMBOL];
	// 
	char fund_name[LEN_NAME];
	//   --ָʱ[ʼʱ,ʱ]ڵĹ
	char pub_date[LEN_ISO_DATATIME];
	//  -- ֲֹֽ
	char period_end[LEN_ISO_DATATIME];
	// Ʊ
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// ֲֹ
	double hold_share;
	// ֲֵ
	double hold_value;
	// ռֵ  --λ%
	double nv_rate;
	// ռܹɱ --λ%
	double ttl_share_rate;
	// ռͨɱ --λ%s
	double circ_share_rate;
};

struct FndPortfolioBondInfo
{
	//   --ѯʲϵĻ
	char fund[LEN_SYMBOL];
	// 
	char fund_name[LEN_NAME];
	//   --ָʱ[ʼʱ,ʱ]ڵĹ
	char pub_date[LEN_ISO_DATATIME];
	//  -- ֲֹֽ
	char period_end[LEN_ISO_DATATIME];
	// Ʊ
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// ֲֹ
	double hold_share;
	// ֲֵ
	double hold_value;
	// ռֵ --λ%
	double nv_rate;
};

struct FndPortfolioFundInfo
{
	//   --ѯʲϵĻ
	char fund[LEN_SYMBOL];
	// 
	char fund_name[LEN_NAME];
	//   --ָʱ[ʼʱ,ʱ]ڵĹ
	char pub_date[LEN_ISO_DATATIME];
	//  -- ֲֹֽ
	char period_end[LEN_ISO_DATATIME];
	// Ʊ
	char symbol[LEN_SYMBOL];
	// Ʊ
	char sec_name[LEN_NAME];
	// ֲֹ
	double hold_share;
	// ֲֵ
	double hold_value;
	// ռֵ --λ%
	double nv_rate;
};

struct FndNetValueInfo
{
	//   --ѯֵĻ
	char fund[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// λֵ  --TյλֵÿݶTյľֵҲļ۸
	double unit_nv;
	// ۼƵλֵ  --Tۼƾֵָڻ֮Ͷʸû1ԪǮֺֽ췽ʽ£T˻ľֵ
	double unit_nv_accu;
	// Ȩλֵ  --TոȨֵָڻ֮Ͷʸû1ԪǮڷֺͶʷʽ£T˻ľֵ
	double unit_nv_adj;
};

struct FndShareRecord
{
	// 
	char fund[LEN_SYMBOL];
	// ף䶯
	char trade_date[LEN_ISO_DATATIME];
	// 
	char pub_date[LEN_ISO_DATATIME];
	// ǰģ, λ
	double share;
};

struct BndConversionPrice
{
	// 
	char pub_date[LEN_ISO_DATATIME];
	// תɼ۸Ч
	char effective_date[LEN_ISO_DATATIME];
	// ִ
	char execution_date[LEN_ISO_DATATIME];
	// תɼ۸ --λԪ
	double conversion_price;
	// תɱ --λ%
	double conversion_rate;
	// λ
	double conversion_volume;
	// ۼתɽ --λԪۼתծѾתΪƱĽۼÿתɽ
	double conversion_amount_total;
	// ծȯͨ --λԪ
	double bond_float_amount_remain;
	// ¼  --ʼתɼۣתɼۣתɼ
	char event_type[LEN_INFO];
	// תɼ۱䶯ԭ
	char change_reason[LEN_COMMENT];
};

struct BndCallInfo
{
	//  --ع
	char pub_date[LEN_ISO_DATATIME];
	//  --Ȩգʵʣڼջ˳Ϊǽڼ
	char call_date[LEN_ISO_DATATIME];
	// صǼ --۵Ǽգǽڼ
	char record_date[LEN_ISO_DATATIME];
	// ʽ --Ͷؿ
	char cash_date[LEN_ISO_DATATIME];
	//  --أȫ
	char call_type[LEN_INFO];
	// ԭ --1:2:ǿأ3:
	char call_reason[LEN_INFO];
	// ؼ۸ --λԪ/ţÿԪֵؼ۸Ԫծȯֵ ӵӦϢ˰
	double call_price;
	// ؽ
	double call_amount;
	// ǷϢ  -- 0:1:
	bool interest_included;
};

struct BndPutInfo
{
	//  --ع
	char pub_date[LEN_ISO_DATATIME];
	// ʼ --ͶȨʼ
	char put_start_date[LEN_ISO_DATATIME];
	// ۽ֹ --ͶȨֹ
	char put_end_date[LEN_ISO_DATATIME];
	// ʽ --Ͷ߻ۿ
	char cash_date[LEN_ISO_DATATIME];
	// ԭ --1:2:㸽ӻ
	char put_reason[LEN_INFO];
	// ۼ۸ --λԪ/ţÿԪֵۼ۸Ԫծȯֵ ӵӦϢ˰
	double put_price;
	// ۽
	double put_amount;
	// ǷϢ  -- 0:1:
	bool   interest_included;
};

struct BndAmountChange
{
	// 
	char pub_date[LEN_ISO_DATATIME];
	// 䶯 --׷ת ء(ע)
	char change_type[LEN_INFO];
	// 䶯
	char change_date[LEN_ISO_DATATIME];
	// α䶯 --λԪ
	double change_amount;
	// ʣ --䶯λԪ
	double remain_amount;
};

struct BndAnalysisRecord
{
	// תծ
	char symbol[LEN_SYMBOL];
	// 
	char trade_date[LEN_ISO_DATATIME];
	// תɼֵ
	double cnv_value;
	// ת
	double cnv_premium;
	// ת(%)
	double cnv_premium_rate;
	// ռ
	double arbitrage;
	// (%)
	double cur_yield;
	// ծֵ(ծ׼)
	double pure_value_cb;
	// ծֵ(֤׼)
	double pure_value_csi;
	// ծ
	double pure_premium;
	// ծ(%)
	double pure_premium_rate;
	// ƽ۵׼(%)
	double floor_premium_rate;
	// תϡ(%)
	double cnv_dil_rate;
	// ͨϡ(%)
	double circ_dil_rate;
};

#endif
